<?php
session_start();
$conn = new mysqli('localhost', 'yoveraes_userdb', 't7@s5FxYn1GB', 'yoveraes_botica');

$cliente = $_POST['cliente'] ?? null;
$metodo = $_POST['metodo'] ?? null;
$productos = $_POST['productos'] ?? [];
$id_user = $conn->real_escape_string($_SESSION['idusuario']);
$correo = $conn->real_escape_string($_SESSION['correo']);

if (empty($productos) || !is_array($productos)) {
    echo 'Error: No hay productos en la solicitud.';
    exit;
}

$conn->begin_transaction();
try {
    // Insertar venta
    $sql = "INSERT INTO ventas (fecha, cliente, metodo, total, id_usuario, correo) VALUES (NOW(), ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare(query: $sql);
    $total = array_sum(array_column($productos, 'subtotal'));
    $stmt->bind_param('ssd', $cliente, $metodo, $total);
    $stmt->execute();
    $id_venta = $conn->insert_id;

    // Insertar detalles y actualizar stock
    foreach ($productos as $producto) {
        $sql = "INSERT INTO detalle_ventas (id_venta, id_producto, cantidad, precio) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param('iiidd', $id_venta, $producto['id'], $producto['cantidad'], $producto['precio']);
        $stmt->execute();

        // Actualizar stock
        $sql = "UPDATE producto SET existencia = existencia - ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param('ii', $producto['cantidad'], $producto['codproducto']);
        $stmt->execute();
    }

    $conn->commit();
    echo 'Venta guardada con éxito';
} catch (Exception $e) {
    $conn->rollback();
    echo 'Error: ' . $e->getMessage();
}