<!-- index.php - Reporte de pedidos pendientes -->
<?php
require('conexionn.php');
$sql = "SELECT id, fecha, cliente, total, num_docpe,hora_vtab,doc_ident, metodo FROM ventas";
$result = $conn->query($sql);
$contador = 1;
// Fechas por defecto: mes anterior o valores enviados por GET
$fecha_inicio = date('Y-m-01');
date_default_timezone_set('America/Lima');
$fecha_fin = $_GET['fecha_fin'] ?? date('Y-m-d');
?>
<!DOCTYPE html>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Caja Diaria</title>
    <script src="/Botica/views/ventas/js/jquery.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css"
        integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
    <script language="javascript" src="/Botica/views/ventas/js/jquery-3.1.1.min.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script language="javascript"></script>
    <style>
        /* Estilos personalizados para el botón */
        .boton-personalizado {
            background-color: #4CAF50;
            /* Verde */
            border: none;
            color: white;
            padding: 15px 32px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 18px;
            margin: 4px 2px;
            cursor: pointer;
            border-radius: 12px;
        }

        .boton-personalizado:hover {
            background-color: #45a049;
            /* Verde más oscuro */
        }
    </style>
    <style>
        /* Estilos básicos */
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }

        .container {
            max-width: 1000px;
            margin: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            padding: 10px;
            border: 1px solid #ccc;
            text-align: center;
        }

        button {
            padding: 5px 10px;
            color: #fff;
            background: #e74c3c;
            border: none;
            cursor: pointer;
        }

        button:hover {
            background: #c0392b;
        }
    </style>
    <style>
        /* Estilo para reducir la fuente */
        .tabla-pequena {
            font-size: 14px;
            /* Ajusta el tamaño de la fuente */
            border-collapse: collapse;
            width: 100%;
        }

        .tabla-pequena th,
        .tabla-pequena td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        .tabla-pequena th {
            background-color: #3e64d3;
            text-align: left;
        }
    </style>
    <script>
        // Función para sumar los valores de la columna de montos
        function sumarMontos() {
            let total = 0;
            let montos = document.querySelectorAll('.total'); // Seleccionamos todos los elementos con la clase 'monto'
            montos.forEach(function (element) {
                total += parseFloat(element.innerText) || 0;  // Sumamos el contenido de cada elemento
            });
            // Mostrar el total en el campo de texto con id "totalMonto"
            document.getElementById('totalMonto').value = total.toFixed(2);
        }
    </script>
    <script>
        function obtenerNumeroCorrelativo() {
            var tipo = document.getElementById("tipo_cpe").value;
            var xhr = new XMLHttpRequest();
            xhr.open("POST", "/Botica/views/ventas/mostrar_comprobantes.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.onload = function () {
                if (xhr.status === 200) {
                    // Actualizar el valor del campo de texto con el resultado recibido
                    document.getElementById("numero_correlativo").value = xhr.responseText;
                } else {
                    document.getElementById("numero_correlativo").value = "Error al obtener el número.";
                }
            };
            xhr.send("tipo_cpe=" + encodeURIComponent(tipo));
        }
    </script>
    <script>
        // Cambiar color al enfocar
        function changeColor(element, color) {
            element.style.backgroundColor = color;
        }

        // Restaurar color al salir
        function resetColor(element) {
            element.style.backgroundColor = '';
        }
    </script>
</head>

<body onload="buscarVentas()">
    <h2 class="subtitle"><i class="fas fa-clipboard-check"></i> &nbsp;Reporte Total de Ventas | Ventas</h2>
    <form id="filtro-form">
        <label>Desde: <input onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)" type="date"
                id="fecha_inicio" value="<?= $fecha_inicio ?>"></label>
        <label>Hasta: <input onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)" type="date" id="fecha_fin"
                value="<?= $fecha_fin ?>"></label>
        <label>Tipo de documento:
            <select id="tipo_doc" onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)">
                <option value="">Todos</option>
                <option value="B">Boleta</option>
                <option value="F">Factura</option>
                <option value="N">Nota de Venta</option>
            </select>
        </label>
        <label>Número de Documento: <input onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)" type="text"
                id="num_doc"></label>
        <button type="button" class="btn btn-success" onclick="buscarVentas()"><i
                class="fas fa-search"></i>&nbsp;Buscar</button>
    </form>

    <table border="1" class="table table-striped table-hover tabla-pequena" style="width: 100%;">
        <thead class="table-dark table-bordered">
            <tr>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;font-size:16px;font-weight-bold;">It.
                </th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;font-size:16px;font-weight-bold;">
                    Fecha</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;font-size:16px;font-weight-bold;">
                    Documento</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;font-size:16px;font-weight-bold;">
                    Cliente</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;font-size:16px;font-weight-bold;">
                    Forma de Pago</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;font-size:16px;font-weight-bold;">
                    Total</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;font-size:16px;font-weight-bold;">
                    Acción</th>
            </tr>
        </thead>
        <tbody id="ventas-body">
            <!-- Aquí se mostrarán los datos -->
        </tbody>
    </table>

    <script>
        function buscarVentas() {
            let fecha_inicio = $("#fecha_inicio").val();
            let fecha_fin = $("#fecha_fin").val();
            let tipo_doc = $("#tipo_doc").val();
            let num_doc = $("#num_doc").val();
            $.ajax({
                url: "/Botica/views/ventas/reporte_ventas.php",
                type: "GET",
                data: { fecha_inicio, fecha_fin, tipo_doc, num_doc },
                success: function (response) {
                    $("#ventas-body").html(response);
                }
            });
            let fechaInicio = document.getElementById('fecha_inicio').value;
            let fechaFin = document.getElementById('fecha_fin').value;
            // Realizamos la petición AJAX con Fetch API
            fetch(`/Botica/views/ventas/cargar_vtatotales.php?fecha_inicio=${fechaInicio}&fecha_fin=${fechaFin}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('totalC').value = parseFloat(data.contado).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    document.getElementById('totalT').value = parseFloat(data.transferencia).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    document.getElementById('totalY').value = parseFloat(data.yape).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    document.getElementById('totalP').value = parseFloat(data.plin).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    document.getElementById('totalO').value = parseFloat(data.otro).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    document.getElementById('total').value = parseFloat(data.total).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                })
                .catch(error => console.error('Error:', error));
        }

        function reimprimirDocumento(id, tipo) {
            window.open("/Botica/views/ventas/reimprimir.php?id=" + id + "&tipo=" + tipo, "_blank");
        }

        function anularDocumento(idventa, numdoc) {
            if (confirm("¿Seguro que deseas anular la Documento N° " + numdoc + "?")) {
                $.ajax({
                    url: "/Botica/views/ventas/anular_venta.php",
                    type: "POST",
                    data: { idventa: idventa },
                    success: function (response) {
                        alert(response);
                        location.reload(); // Recarga la tabla
                    },
                    error: function (xhr, status, error) {
                        alert("Error al anular: " + error);
                    }
                });
            }
        }
    </script>
    <div class="form-container">
        <div class="card-body">
            <div class="row">
                <hr>
                <div class="col-md-7">
                    <label for="totalC" style="font-size:16px; color:rgb(25,54,93);height:10px;"><strong>Caja Diaria
                            Contado</strong></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <input style="width: 80; font-size:16px; cursor:pointer;text-align: right;" type="text" id="totalC"
                        name="totalC" readonly>
                </div>
                <div class="col-md-7">
                    <label for="totalT" style="font-size:16px; color:rgb(25,54,93);height:10px;"><strong>Caja Diaria
                            Transferencia</strong></label>&nbsp;&nbsp;&nbsp;
                    <input style="width: 80; font-size:16px; cursor:pointer;text-align: right;" type="text" id="totalT"
                        name="totalT" readonly>
                </div>
                <div class="col-md-7">
                    <label for="totalY" style="font-size:16px; color:rgb(25,54,93);height:10px;"><strong>Caja Diaria
                            Yape</strong></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <input style="width: 80; font-size:16px; cursor:pointer;text-align: right;" type="text" id="totalY"
                        name="totalY" readonly>
                </div>
                <div class="col-md-7">
                    <label for="totalP" style="font-size:16px; color:rgb(25,54,93);height:10px;"><strong>Caja Diaria
                            Plin</strong></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <input style="width: 200; font-size:16px; cursor:pointer;text-align: right;" type="text" id="totalP"
                        name="totalP" readonly>
                </div>
                <div class="col-md-7">
                    <label for="totalO" style="font-size:16px; color:rgb(25,54,93);height:10px;"><strong>Caja Diaria
                            Otro</strong></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <input style="width: 80; font-size:16px; cursor:pointer;text-align: right;" type="text" id="totalO"
                        name="totalO" readonly>
                </div>
                <hr>
                <div class="col-md-6">
                    <div class="input-group mb-5">
                        <label for="total" style="font-size:22px; color:rgb(25,54,93);"><strong>Caja Diaria
                                Total S/. </strong></label>&nbsp;&nbsp;&nbsp;&nbsp;
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="far fa-money-bill-alt"></i></span>
                            <input style="width: 150px; font-size:22px; cursor:pointer;text-align: right;" type="text"
                                id="total" name="total" readonly>
                        </div>
                    </div>
                    <hr>
                </div>
            </div>
        </div>
    </div>

</body>

</html>