<?php
include 'config.php';

// Obtener datos para reportes
try {
    // Total por día del mes actual
    $sql_diario = "SELECT DATE(fecha) as dia, 
                  SUM(CASE WHEN tipo = 'ingreso' THEN monto ELSE 0 END) as ingresos,
                  SUM(CASE WHEN tipo = 'egreso' THEN monto ELSE 0 END) as egresos
                  FROM caja 
                  WHERE MONTH(fecha) = MONTH(CURRENT_DATE()) 
                  AND YEAR(fecha) = YEAR(CURRENT_DATE())
                  GROUP BY DATE(fecha) 
                  ORDER BY dia DESC 
                  LIMIT 30";
    $movimientos_diarios = $conn->query($sql_diario)->fetchAll(PDO::FETCH_ASSOC);

    // Total por tipo este mes
    $sql_mensual = "SELECT tipo, SUM(monto) as total 
                   FROM caja 
                   WHERE MONTH(fecha) = MONTH(CURRENT_DATE()) 
                   AND YEAR(fecha) = YEAR(CURRENT_DATE())
                   GROUP BY tipo";
    $totales_mensuales = $conn->query($sql_mensual)->fetchAll(PDO::FETCH_ASSOC);

    $ingresos_mes = 0;
    $egresos_mes = 0;
    foreach ($totales_mensuales as $total) {
        if ($total['tipo'] == 'ingreso') {
            $ingresos_mes = $total['total'];
        } else {
            $egresos_mes = $total['total'];
        }
    }
    $saldo_mes = $ingresos_mes - $egresos_mes;

} catch (PDOException $e) {
    die("Error: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title>Reportes de Caja</title>
    <style>
        * {
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Arial;
            margin: 0;
            padding: 20px;
            background: #f0f2f5;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
        }

        h2 {
            color: #2c3e50;
            text-align: center;
            margin-bottom: 30px;
        }

        .grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 30px;
        }

        .card {
            background: white;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 2px 15px rgba(0, 0, 0, 0.1);
        }

        .resumen-mes {
            grid-column: 1 / -1;
        }

        .kpi {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
            margin-bottom: 20px;
        }

        .kpi-item {
            padding: 20px;
            border-radius: 8px;
            color: white;
            text-align: center;
        }

        .kpi-ingresos {
            background: linear-gradient(135deg, #27ae60, #2ecc71);
        }

        .kpi-egresos {
            background: linear-gradient(135deg, #e74c3c, #c0392b);
        }

        .kpi-saldo {
            background: linear-gradient(135deg, #3498db, #2980b9);
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        th,
        td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ecf0f1;
        }

        th {
            background: #34495e;
            color: white;
        }

        .acciones {
            text-align: center;
            margin: 30px 0;
        }

        .btn {
            display: inline-block;
            padding: 12px 25px;
            margin: 0 10px;
            background: #2c3e50;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            transition: background 0.3s;
        }

        .btn:hover {
            background: #34495e;
        }

        .btn-primary {
            background: #3498db;
        }

        .btn-primary:hover {
            background: #2980b9;
        }

        .positivo {
            color: #27ae60;
            font-weight: bold;
        }

        .negativo {
            color: #e74c3c;
            font-weight: bold;
        }

        @media (max-width: 768px) {
            .grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <h2>📈 Reporte Caja | Ingresos - Egresos</h2>

        <div class="acciones">
            <a href="formulario_caja.php" class="btn">➕ Nuevo Movimiento</a>
            <a href="ver_movimientos.php" class="btn btn-primary">📊 Ver Movimientos</a>
        </div>

        <!-- Resumen del Mes -->
        <div class="card resumen-mes">
            <h3>📅 Resumen del Mes Actual</h3>
            <div class="kpi">
                <div class="kpi-item kpi-ingresos">
                    <h4>TOTAL INGRESOS</h4>
                    <p style="font-size: 28px; margin: 10px 0;">S/ <?php echo number_format($ingresos_mes, 2); ?></p>
                </div>
                <div class="kpi-item kpi-egresos">
                    <h4>TOTAL EGRESOS</h4>
                    <p style="font-size: 28px; margin: 10px 0;">S/ <?php echo number_format($egresos_mes, 2); ?></p>
                </div>
                <div class="kpi-item kpi-saldo">
                    <h4>SALDO DEL MES</h4>
                    <p style="font-size: 28px; margin: 10px 0;">S/ <?php echo number_format($saldo_mes, 2); ?></p>
                </div>
            </div>
        </div>

        <div class="grid">
            <!-- Movimientos Diarios -->
            <div class="card">
                <h3>📊 MOVIMIENTOS DIARIOS (Últimos 30 días)</h3>
                <table>
                    <thead>
                        <tr>
                            <th>Fecha</th>
                            <th>Ingresos</th>
                            <th>Egresos</th>
                            <th>Saldo</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($movimientos_diarios as $mov): ?>
                            <tr>
                                <td><?php echo date('d/m/Y', strtotime($mov['dia'])); ?></td>
                                <td class="positivo">S/ <?php echo number_format($mov['ingresos'], 2); ?></td>
                                <td class="negativo">S/ <?php echo number_format($mov['egresos'], 2); ?></td>
                                <td
                                    style="font-weight: bold; color: <?php echo ($mov['ingresos'] - $mov['egresos']) >= 0 ? '#27ae60' : '#e74c3c'; ?>">
                                    S/ <?php echo number_format($mov['ingresos'] - $mov['egresos'], 2); ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <?php if (empty($movimientos_diarios)): ?>
                    <p style="text-align: center; color: #7f8c8d;">No hay movimientos este mes</p>
                <?php endif; ?>
            </div>

            <!-- Estadísticas -->
            <div class="card">
                <h3>📈 ESTADÍSTICAS</h3>
                <div style="margin: 20px 0;">
                    <h4>Distribución del Mes</h4>
                    <p><strong>Ingresos:</strong> S/ <?php echo number_format($ingresos_mes, 2); ?></p>
                    <p><strong>Egresos:</strong> S/ <?php echo number_format($egresos_mes, 2); ?></p>
                    <p><strong>Saldo:</strong>
                        <span style="color: <?php echo $saldo_mes >= 0 ? '#27ae60' : '#e74c3c'; ?>; font-weight: bold;">
                            S/ <?php echo number_format($saldo_mes, 2); ?>
                        </span>
                    </p>
                </div>
                <div style="margin: 20px 0;">
                    <h4>Promedio Diario</h4>
                    <p><strong>Ingresos:</strong> S/ <?php echo number_format($ingresos_mes / 30, 2); ?></p>
                    <p><strong>Egresos:</strong> S/ <?php echo number_format($egresos_mes / 30, 2); ?></p>
                </div>
            </div>
        </div>
    </div>
</body>

</html>