<!-- index.php - Reporte de pedidos pendientes -->
<?php
session_start();
require('conexionn.php');
$sql = "SELECT id, fecha, cliente, total, num_docpe,hora_vtap, direccion, doc_ident FROM ventas  WHERE tipo_doc = 'P'";
$result = $conn->query($sql);
$contador = 1;
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Caja Diaria</title>
    <script src="/Botica/views/ventas/js/jquery.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css"
        integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
    <script language="javascript" src="/Botica/views/ventas/js/jquery-3.1.1.min.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script language="javascript"></script>
    <style>
        /* Estilos personalizados para el botón */
        .boton-personalizado {
            background-color: #4CAF50;
            /* Verde */
            border: none;
            color: white;
            padding: 15px 32px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 18px;
            margin: 4px 2px;
            cursor: pointer;
            border-radius: 12px;
        }

        .boton-personalizado:hover {
            background-color: #45a049;
            /* Verde más oscuro */
        }
    </style>
    <style>
        /* Estilos básicos */
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }

        .container {
            max-width: 1000px;
            margin: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            padding: 10px;
            border: 1px solid #ccc;
            text-align: center;
        }

        button {
            padding: 5px 10px;
            color: #fff;
            background: #e74c3c;
            border: none;
            cursor: pointer;
        }

        button:hover {
            background: #c0392b;
        }
    </style>
    <style>
        /* Estilo para reducir la fuente */
        .tabla-pequena {
            font-size: 14px;
            /* Ajusta el tamaño de la fuente */
            border-collapse: collapse;
            width: 100%;
        }

        .tabla-pequena th,
        .tabla-pequena td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        .tabla-pequena th {
            background-color: #3e64d3;
            text-align: left;
        }
    </style>
    <script>
        // Función para sumar los valores de la columna de montos
        function sumarMontos() {
            let total = 0;
            let montos = document.querySelectorAll('.total'); // Seleccionamos todos los elementos con la clase 'monto'
            montos.forEach(function (element) {
                total += parseFloat(element.innerText) || 0;  // Sumamos el contenido de cada elemento
            });
            // Mostrar el total en el campo de texto con id "totalMonto"
            document.getElementById('totalMonto').value = total.toFixed(2);
        }
    </script>
    <script>
        function obtenerNumeroCorrelativo() {
            var tipo = document.getElementById("tipo_cpe").value;
            var xhr = new XMLHttpRequest();
            xhr.open("POST", "/Botica/views/ventas/mostrar_comprobantes.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.onload = function () {
                if (xhr.status === 200) {
                    // Actualizar el valor del campo de texto con el resultado recibido
                    document.getElementById("numero_correlativo").value = xhr.responseText;
                } else {
                    document.getElementById("numero_correlativo").value = "Error al obtener el número.";
                }
            };
            xhr.send("tipo_cpe=" + encodeURIComponent(tipo));
        }
    </script>
    <script>
        // Cambiar color al enfocar
        function changeColor(element, color) {
            element.style.backgroundColor = color;
        }

        // Restaurar color al salir
        function resetColor(element) {
            element.style.backgroundColor = '';
        }
    </script>
</head>
<h2 class="subtitle"><i class="fas fa-clipboard-check"></i> &nbsp;Generar C.P.E.(Boleta/Factura) | Pedidos Pendientes
</h2>

<body>
    <table border="1" class="table table-striped table-hover tabla-pequena" style="width: 100%;">
        <thead class="table-dark table-bordered">
            <tr>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;font-size:16px;font-weight-bold;">It.
                </th>
                <th style="display:none;">Id</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;font-size:16px;font-weight-bold;">
                    Fecha</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;font-size:16px;font-weight-bold;">N°
                    Pedido</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;font-size:16px;font-weight-bold;">
                    Hora Venta</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;font-size:16px;font-weight-bold;">
                    Cliente</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;font-size:16px;font-weight-bold;">
                    DNI/RUC</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;font-size:16px;font-weight-bold;">
                    Dirección</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;font-size:16px;font-weight-bold;">
                    Total</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;font-size:16px;font-weight-bold;">
                    Acciones</th>
            </tr>
        </thead>
        <?php while ($row = $result->fetch_assoc()) { ?>
            <tr>
                <td style="text-align:center;"> <?php echo $contador++; ?> </td>
                <td style="display:none;cursor:pointer;color:rgb(0,0,0);text-align:center;"><?php echo $row['id']; ?></td>
                <td style="cursor:pointer;color:rgb(0,0,0);text-align:center;"><?php echo $row['fecha']; ?></td>
                <td style="cursor:pointer;color:rgb(0,0,0);text-align:center;"><?php echo $row['num_docpe']; ?></td>
                <td style="cursor:pointer;color:rgb(0,0,0);text-align:center;"><?php echo $row['hora_vtap']; ?></td>
                <td style="cursor:pointer;color:rgb(0,0,0);text-align:left;"><?php echo $row['cliente']; ?></td>
                <td style="cursor:pointer;color:rgb(0,0,0);text-align:center;"> <?php echo $row['doc_ident']; ?> </td>
                <td style="cursor:pointer;color:rgb(0,0,0);text-align:left;"><?php echo $row['direccion']; ?></td>
                <td style="cursor:pointer;color:rgb(0, 0, 255);text-align:right;font-weight-bold;">
                    <?php echo number_format($row['total'], 2); ?>
                </td>
                <td>
                    <button class="btn-success btn-sm"
                        onclick="abrirModal('<?php echo $row['id']; ?>','<?php echo $row['cliente']; ?>','<?php echo $row['doc_ident']; ?>','<?php echo $row['direccion']; ?>','<?php echo $row['total']; ?>')"><i
                            class="fas fa-file-signature"></i>Generar</button>
                </td>
            </tr>
        <?php } ?>
    </table>


    <!-- Modal -->
    <div id="modal"
        style="display:none; position:fixed; top:20%; left:50%; transform:translate(-50%, -20%); background:#fff; padding:50px; border:1px solid black;">
        <h3><i class="fas fa-clipboard-check"></i> &nbsp;GENERAR BOLETA - FACTURA </h3>
        <hr>
        <input type="hidden" id="pedido_id">
        <p><strong>Cliente : </strong> <span id="modal_cliente"></span></p>
        <p><strong>DNI/RUC : </strong> <span id="modal_dni"></span></p>
        <p><strong>Dirección : </strong> <span id="modal_direccion"></span></p>


        <div class="accordion" id="accordionPedidos">
            <div class="accordion-item">
                <h2 class="accordion-header" id="headingOne">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                        Detallado de Productos del Pedido
                    </button>
                </h2>
                <div id="collapseOne" class="accordion-collapse collapse" aria-labelledby="headingOne"
                    data-bs-parent="#accordionPedidos">
                    <div class="accordion-body">
                        <table class="table table-striped table-hover tabla-pequena" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th
                                        style="cursor:pointer;color:rgb(255,255,255);text-align:center;font-size:16px;font-weight-bold;">
                                        Producto</th>
                                    <th
                                        style="cursor:pointer;color:rgb(255,255,255);text-align:center;font-size:16px;font-weight-bold;">
                                        Cantidad</th>
                                    <th
                                        style="cursor:pointer;color:rgb(255,255,255);text-align:center;font-size:16px;font-weight-bold;">
                                        P.Unitario</th>
                                    <th
                                        style="cursor:pointer;color:rgb(255,255,255);text-align:center;font-size:16px;font-weight-bold;">
                                        Total</th>
                                </tr>
                            </thead>
                            <tbody id="detalle_pedido">
                                <tr>
                                    <td colspan="3">Seleccione un pedido...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- Fin acordeón -->

        <p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong
                style="font-size:22px; color:rgb(63,81,181);">Total : S/ </strong>&nbsp;&nbsp;<span
                style="font-size:22px; color:rgb(0,0,255);font-weight-bold;" id="modal_total"></span>
        </p>

        <div class="col-md-11">
            <label><strong style="font-size:16px; color:rgb(25,54,93);">&nbsp;Tipo de Pago</strong></label>
            <select id="metodo" onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)" style="cursor:pointer;"
                class="form-control" onchange="obtenerNumeroCorrelativo()">
                <option value="CONTADO">CONTADO</option>
                <option value="TRANSFERENCIA">TRANSFERENCIA</option>
                <option value="YAPE">YAPE</option>
                <option value="PLIN">PLIN</option>
                <option value="OTRO">OTRO</option>
            </select>
        </div>
        <br>
        <!--select id="formato"-->
        <div class="col-md-11">
            <form id="formulario" onsubmit="event.preventDefault(); obtenerNumeroCorrelativo();">
                <label for="tipo_cpe"><strong style="font-size:16px; color:rgb(25,54,93);">&nbsp;Tipo de
                        Documento</strong><span class="text-danger">*</span></label>
                <div class="input-group mb-11">
                    <select class="form-control" id="tipo_cpe" name="tipo_cpe" onfocus="changeColor(this, '#f7f201')"
                        onblur="resetColor(this)" style="cursor:pointer; width:230px;font-size:16px;font-weight-bold;"
                        onchange="obtenerNumeroCorrelativo();">
                        <option value="A">SELECCIONE</option>
                        <option value="B">BOLETA</option>
                        <option value="F">FACTURA</option>
                        <option value="N">NOTA VENTA</option>
                    </select>
                    <button style="display:none;" type="submit">Mostrar Número Correlativo</button>
                </div>
            </form>
            <label for="numero_correlativo"><strong style="font-size:16px; color:rgb(25,54,93);">&nbsp;N° de
                    Documento</strong><span class="text-danger">*</span></label>
            <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text"><i class="fa fa-credit-card"></i></span>
                </div>
                <input type="text" class="form-control font-weight-bold" id="numero_correlativo"
                    name="numero_correlativo" value="" readonly
                    style="width:200px;font-size:22px;text-align:center;background-color: rgb(25,54,93);color: rgb(255,255,255);">
            </div>
        </div>
        <hr>
        <button class="btn btn-primary" onclick="generarComprobante()"><i
                class="fas fa-file-pdf"></i>&nbsp;&nbsp;Generar</button>
        &nbsp;&nbsp;&nbsp;&nbsp;<button class="btn btn-danger" onclick="cerrarModal()"><i
                class="fas fa-window-close"></i>&nbsp;&nbsp;Cancelar</button>
    </div>

    <script>
        function abrirModal(id, cliente, doc_ident, direccion, total) {
            // Asigna los valores al modal
            $('#pedido_id').val(id);
            $('#modal_cliente').text(cliente);
            $('#modal_dni').text(doc_ident);
            $('#modal_direccion').text(direccion);
            $('#modal_total').text(total);
            //$('#modal').show();
            $('#detalle_pedido').html('<tr><td colspan="3">Cargando...</td></tr>');
            $.ajax({
                url: '/Botica/views/ventas/detalle_pedido.php',
                type: 'POST',
                data: { id_pedido: id },
                dataType: 'json',
                success: function (data) {
                    let contenido = "";
                    if (data.length > 0) {
                        data.forEach(function (item) {
                            contenido += `<tr>
                        <td style="cursor:pointer;color:rgb(0,0,0);text-align:left;">${item.producto}</td>
                        <td style="cursor:pointer;color:rgb(0,0,0);text-align:center;">${item.cantidad}</td>
                        <td style="cursor:pointer;color:rgb(0, 0, 255);text-align:right;font-weight-bold;">${parseFloat(item.precio).toLocaleString('es-PE', { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
                        <td style="cursor:pointer;color:rgb(0, 0, 255);text-align:right;font-weight-bold;"> ${(parseFloat(item.precio) * parseFloat(item.cantidad)).toLocaleString('es-PE', { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
                        
                    </tr>`;
                        });
                    } else {
                        contenido = '<tr><td colspan="3">No hay detalles disponibles.</td></tr>';
                    }
                    $('#detalle_pedido').html(contenido);
                    // Mostrar el modal con Bootstrap 5
                    var modal = new bootstrap.Modal(document.getElementById('modal'));
                    $('#modal').show();
                },
                error: function () {
                    $('#detalle_pedido').html('<tr><td colspan="3">Error al cargar los datos.</td></tr>');
                }
            });
        }
        function cerrarModal() {
            $('#modal').hide();
        }
        function generarComprobante() {
            let id = $('#pedido_id').val();
            let tipo_pago = $('#metodo').val();
            let formato = $('#tipo_cpe').val();
            let numcpe = $('#numero_correlativo').val();
            $.post('/Botica/views/ventas/actualiza_pedido.php', { id: id, tipo_pago: tipo_pago, numcpe: numcpe, formato: formato }, function (response) {
                if (response.status === 'success') {
                    alert(response.message);
                    window.open('/Botica/views/ventas/generar_pdf.php?id=' + id + '&tipo_pago=' + tipo_pago + '&formato=' + formato, '_blank');
                    setTimeout(() => location.reload(), 1000); // Recarga después de 1s
                } else {
                    alert(response.message); // Muestra el error si no se actualiza
                    console.error("Error: ", response.message);
                }
            }, 'json')
                .fail(function (xhr, status, error) {
                    console.error("AJAX Error: ", error);
                    alert("❌ Error en la petición AJAX.");
                });
        }
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>