<?php
session_start();
require('fpdf/fpdf.php'); // Incluye la librería FPDF
error_reporting(E_ALL & ~E_DEPRECATED);
// Conexión a la base de datos
$conn = new mysqli('localhost', 'yoveraes_userdb', 't7@s5FxYn1GB', 'yoveraes_botica');
if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}
function numero_a_letras($numero)
{
    $numeros = array(
        0 => 'Cero',
        1 => 'Uno',
        2 => 'Dos',
        3 => 'Tres',
        4 => 'Cuatro',
        5 => 'Cinco',
        6 => 'Seis',
        7 => 'Siete',
        8 => 'Ocho',
        9 => 'Nueve',
        10 => 'Diez',
        11 => 'Once',
        12 => 'Doce',
        13 => 'Trece',
        14 => 'Catorce',
        15 => 'Quince',
        16 => 'Dieciséis',
        17 => 'Diecisiete',
        18 => 'Dieciocho',
        19 => 'Diecinueve',
        20 => 'Veinte',
        30 => 'Treinta',
        40 => 'Cuarenta',
        50 => 'Cincuenta',
        60 => 'Sesenta',
        70 => 'Setenta',
        80 => 'Ochenta',
        90 => 'Noventa',
        100 => 'Cien',
        200 => 'Doscientos',
        300 => 'Trescientos',
        400 => 'Cuatrocientos',
        500 => 'Quinientos',
        600 => 'Seiscientos',
        700 => 'Setecientos',
        800 => 'Ochocientos',
        900 => 'Novecientos'
    );

    $decimal = "";
    $parte_decimal = "";

    // Si tiene parte decimal
    if (strpos($numero, '.') !== false) {
        list($numero, $decimal) = explode('.', $numero);
    }
    // Convertir parte entera
    if ($numero < 21) {
        $parte_decimal = $numeros[$numero];
    } else if ($numero < 100) {
        $decenas = floor($numero / 10) * 10;
        $unidad = $numero % 10;
        $parte_decimal = $numeros[$decenas];
        if ($unidad > 0) {
            $parte_decimal .= ' y ' . $numeros[$unidad];
        }
    } else if ($numero >= 100) {
        $centenas = floor($numero / 100) * 100;
        $resto = $numero % 100;
        $parte_decimal = $numeros[$centenas];
        if ($resto > 0) {
            $parte_decimal .= ' ' . numero_a_letras($resto);
        }
    }
    return $parte_decimal . ($decimal ? ' con ' . $decimal . '/100 SOLES' : '');
}
// Definición de constantes
define('MONEDA', 'S/. ');
// Establecer la zona horaria (opcional)
date_default_timezone_set('America/Lima');
$hora_actual = date('H:i:s');
// Obtener el id_venta desde la URL
$id_venta = $_GET['id'] ?? null;
if (!$id_venta) {
    die("ID de venta no proporcionado.");
}
// Consultar los datos de la venta
$query = "SELECT * FROM ventas WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $id_venta);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $venta = $result->fetch_assoc();
    $tipo_documento = $venta['tipo_doc'];
    $termsal8 = $venta['num_docpe'];
    $termsal4 = $venta['fecha'];
    $termsal5 = $venta['metodo'];
    $correo = $venta['correo'];
    $termsal9 = $venta['ruc_emp'];
    $termsal10 = $venta['nom_emp'];
    $termsal11 = $venta['dom_pasajero'];
    $salidaz = $venta['t_origen'];
    $termsal = $venta['doc_ident'];
    $choferez2 = $venta['Nom_pasajero'];
    $salidaz = $venta['t_origen'];
    $llegadaz = $venta['t_destino'];
    $diaz = $venta['t_fecha'];
    $termsal6 = $venta['total'];
    $total_venta = $venta['total'];
    $consulta = "SELECT * FROM origen WHERE nombre='$salidaz' and telefono='ORIGEN'";
    $resultado = mysqli_query($conn, $consulta) or die("No se puede ejecutar la consulta");
    $columna = mysqli_fetch_array($resultado);
    $fabricacion = $columna[3];
    // Consultar los detalles de la venta
    $query_detalles = "SELECT * FROM temp_vta WHERE idventa = ?";
    $stmt_detalles = $conn->prepare($query_detalles);
    $stmt_detalles->bind_param("i", $id_venta);
    $stmt_detalles->execute();
    $result_detalles = $stmt_detalles->get_result();
    if ($result_detalles->num_rows > 0) {
        $ventaD = $result_detalles->fetch_assoc();
        $tiempoz = $ventaD['t_hora'];
        $termsal3 = $ventaD['t_asiento'];
    }
    // Crear instancia de FPDF
    $pdf = new FPDF('P', 'mm', array(80, 300));
    $pdf->AddPage();
    $pdf->SetMargins(5, 5, 5);
    $pdf->SetFont('Arial', 'B', 9);
    // Agregar logo
    $pdf->Image('img/logo.png', 15, 2, 45);
    $pdf->SetFont('Times', 'B', 9);
    $pdf->Image('img/logo.png', 5, 1, 70); //logo de la empresa,moverDerecha,moverAbajo,tamañoIMG
    $pdf->SetFont('Arial', 'B', 8); //tipo fuente, negrita(B-I-U-BIU), tamañoTexto
    $pdf->Cell(26); // Movernos a la derecha
    $pdf->SetTextColor(0, 0, 0); //color
    $pdf->Cell(7, 50, 'R.U.C. 10473067035', 0, 1, 'C', 0);
    $pdf->Ln(-22);
    /* RUC */
    $pdf->Cell(20);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 1, mb_convert_encoding("De : Romero Correa Fernando S.", 'ISO-8859-1'), 0, 0, '', 0);
    $pdf->Ln(2);
    /* SERVICIO */
    $pdf->Cell(25);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(1, 5, mb_convert_encoding("Telef.: 947591992", 'ISO-8859-1'), 0, 0, '', 0);
    $pdf->Ln(4);
    /* SERVICIO */
    $pdf->Cell(7);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 9);
    if ($tipo_documento === 'B') {
        $pdf->Cell(0, 5, mb_convert_encoding("BOLETA DE VENTA ELECTRONICA", 'ISO-8859-1'), 0, 0, '', 0);
    } elseif ($tipo_documento === 'F') {
        $pdf->Cell(0, 5, mb_convert_encoding("          FACTURA ELECTRONICA", 'ISO-8859-1'), 0, 0, '', 0);
    } elseif ($tipo_documento === 'N') {
        $pdf->Cell(0, 5, mb_convert_encoding("               NOTA DE VENTA", 'ISO-8859-1'), 0, 0, '', 0);
    } else {
        echo "Tipo de documento no válido.";
    }
    $pdf->Ln(-1);
    $pdf->Cell(25);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 9);
    $pdf->Cell(1, 15, mb_convert_encoding($termsal8, 'ISO-8859-1'), 0, 0, '', 0);
    $pdf->Ln(2);
    $pdf->SetDrawColor(0, 0, 0);
    $pdf->Line(0, 55, 600, 55);

    //--------CUERPO 1 TEXT1--------//
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    // Texto con diferentes fuentes
    $texto1a = mb_convert_encoding("Fecha de Emisión :", 'ISO-8859-1');
    $texto1b = ' ' . $termsal4 . ' - ' . $hora_actual;
    // Otro ejemplo con Write() para más flexibilidad
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(9, $texto1a);
    $pdf->SetFont('Arial', '', 8); // Texto normal
    $pdf->Write(9, $texto1b);

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    // Texto con diferentes fuentes
    $texto1c = mb_convert_encoding("Usuario :", 'ISO-8859-1');
    $texto1d = ' ' . $correo;
    // Otro ejemplo con Write() para más flexibilidad
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(6, $texto1c);
    $pdf->SetFont('Arial', '', 8); // Texto normal
    $pdf->Write(6, $texto1d);

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    // Texto con diferentes fuentes
    $texto1e = mb_convert_encoding("R.U.C. :", 'ISO-8859-1');
    $texto1f = ' ' . $termsal9;
    // Otro ejemplo con Write() para más flexibilidad
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5.5, $texto1e);
    $pdf->SetFont('Arial', '', 8); // Texto normal
    $pdf->Write(5.5, $texto1f);

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    // Texto con diferentes fuentes
    $texto1g = mb_convert_encoding("Empresa :", 'ISO-8859-1');
    $texto1h = ' ' . $termsal10;
    // Otro ejemplo con Write() para más flexibilidad
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5.5, $texto1g);
    $pdf->SetFont('Arial', '', 8); // Texto normal
    $pdf->Write(5.5, $texto1h);

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    // Texto con diferentes fuentes
    $texto1i = mb_convert_encoding("Dirección :", 'ISO-8859-1');
    $texto1j = ' ' . $termsal11;
    // Otro ejemplo con Write() para más flexibilidad
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5.5, $texto1i);
    $pdf->SetFont('Arial', '', 8); // Texto normal
    $pdf->Write(5.5, $texto1j);
    //------------------------------//

    $pdf->SetDrawColor(0, 0, 0);
    $pdf->Line(0, 85, 600, 85);

    //--------CUERPO 2 TEXT2--------//
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto2a = mb_convert_encoding("Doc.Ident. :", 'ISO-8859-1');
    $texto2b = ' ' . $termsal;
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(8, $texto2a);
    $pdf->SetFont('Arial', '', 8); // Texto normal
    $pdf->Write(8, $texto2b);

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto2c = mb_convert_encoding("Nombre :", 'ISO-8859-1');
    $texto2d = ' ' . $choferez2;
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5.5, $texto2c);
    $pdf->SetFont('Arial', '', 8); // Texto normal
    $pdf->Write(5.5, $texto2d);

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto2e = mb_convert_encoding("Tipo de Venta :", 'ISO-8859-1');
    $texto2f = ' ' . $termsal5;
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5.5, $texto2e);
    $pdf->SetFont('Arial', '', 8); // Texto normal
    $pdf->Write(5.5, $texto2f);

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto2g = mb_convert_encoding("Oficina :", 'ISO-8859-1');
    $texto2h = ' ' . $salidaz;
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5.5, $texto2g);
    $pdf->SetFont('Arial', '', 8); // Texto normal
    $pdf->Write(5.5, $texto2h);

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto2i = mb_convert_encoding("Dirección :", 'ISO-8859-1');
    $texto2j = ' ' . $fabricacion;
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5.5, $texto2i);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(5.5, $texto2j);
    //------------------------------//

    //--------CUERPO 3 TEXT3--------//
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto3a = mb_convert_encoding("                     DATOS DEL PASAJERO", 'ISO-8859-1');
    $texto3b = ' ';
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5.5, $texto3a);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(4, $texto3b);
    $pdf->SetDrawColor(0, 0, 0);
    $pdf->Line(0, $pdf->GetY(), 200, $pdf->GetY());

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto3b = mb_convert_encoding("Doc.Ident. :", 'ISO-8859-1');
    $texto3c = ' ' . $termsal;
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5, $texto3b);
    $pdf->SetFont('Arial', 'B', 7); // Texto normal
    $pdf->Write(5, $texto3c);

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto3d = mb_convert_encoding("Nombre :", 'ISO-8859-1');
    $texto3e = ' ' . $choferez2;
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5, $texto3d);
    $pdf->SetFont('Arial', 'B', 7); // Texto normal
    $pdf->Write(5, $texto3e);
    //------------------------------//

    //--------CUERPO 4 TEXT4--------//
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto4a = mb_convert_encoding("                        DATOS DEL VIAJE", 'ISO-8859-1');
    $texto4b = ' ';
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5.5, $texto4a);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(4, $texto4b);
    $pdf->SetDrawColor(0, 0, 0);
    $pdf->Line(0, $pdf->GetY(), 200, $pdf->GetY());

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto4c = mb_convert_encoding("RUTA :", 'ISO-8859-1');
    $texto4d = ' ' . $salidaz . ' - ' . $llegadaz;
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5, $texto4c);
    $pdf->SetFont('Arial', 'B', 8); // Texto normal
    $pdf->Write(5, $texto4d);

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto4e = mb_convert_encoding("FECHA DE VIAJE :", 'ISO-8859-1');
    $texto4f = ' ' . $diaz;
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(4.5, $texto4e);
    $pdf->SetFont('Arial', 'B', 8); // Texto normal
    $pdf->Write(4.5, $texto4f);

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto4g = mb_convert_encoding("TURNO :", 'ISO-8859-1');
    $texto4h = ' ' . $tiempoz;
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(4.5, $texto4g);
    $pdf->SetFont('Arial', 'B', 8); // Texto normal
    $pdf->Write(4.5, $texto4h);

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto4i = mb_convert_encoding("NRO.ASIENTO :", 'ISO-8859-1');
    $texto4j = ' ' . $termsal3;
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(4.5, $texto4i);
    $pdf->SetFont('Arial', 'B', 8); // Texto normal
    $pdf->Write(4.5, $texto4j);

    $pdf->SetFont('Arial', 'B', 7); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto4k = mb_convert_encoding("LUGAR DE EMBARQUE :", 'ISO-8859-1');
    $texto4l = ' ' . $salidaz;
    $pdf->SetFont('Arial', 'B', 7); // Texto negrita
    $pdf->Write(4.5, $texto4k);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(4.5, $texto4l);

    $pdf->SetFont('Arial', 'B', 7); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto4m = mb_convert_encoding("DIRECC.DE EMBARQUE :", 'ISO-8859-1');
    $texto4n = ' ' . $fabricacion;
    $pdf->SetFont('Arial', 'B', 6); // Texto negrita
    $pdf->Write(4.5, $texto4m);
    $pdf->SetFont('Arial', '', 6); // Texto normal
    $pdf->Write(4.5, $texto4n);
    //------------------------------//

    //--------CUERPO 5 TEXT5--------//
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto5a = mb_convert_encoding("Op. No Gravada  S/. :", 'ISO-8859-1');
    $texto5b = '                     ' . $termsal6;
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(4.5, $texto5a);
    $pdf->SetFont('Arial', 'B', 8); // Texto normal
    $pdf->Write(4.5, $texto5b);
    $pdf->SetDrawColor(0, 0, 0);
    $pdf->Line(0, $pdf->GetY(), 200, $pdf->GetY());

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto5c = mb_convert_encoding("I.G.V.(18%)         S/. :", 'ISO-8859-1');
    $texto5d = '                          0.00';
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(4.5, $texto5c);
    $pdf->SetFont('Arial', 'B', 8); // Texto normal
    $pdf->Write(4.5, $texto5d);

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto5e = mb_convert_encoding("Importe Total      S/. :", 'ISO-8859-1');
    $texto5f = '                     ' . $termsal6;
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(4.5, $texto5e);
    $pdf->SetFont('Arial', 'B', 8); // Texto normal
    $pdf->Write(4.5, $texto5f);

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto5g = mb_convert_encoding("SON :", 'ISO-8859-1');
    $total_venta_letras = ' ' . numero_a_letras($total_venta);
    $pdf->SetFont('Arial', 'B', 7); // Texto negrita
    $pdf->Write(4.5, $texto5g);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(4.5, strtoupper($total_venta_letras));

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto4aa = mb_convert_encoding("  ", 'ISO-8859-1');
    $texto4bb = ' ';
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5, $texto4aa);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(4, $texto4bb);
    $pdf->SetDrawColor(0, 0, 0);
    $pdf->Line(0, $pdf->GetY(), 200, $pdf->GetY());
    //------------------------------//

    //--------CUERPO 6 TEXT6--------//
    $pdf->SetFont('Arial', '', 7); // Negrita
    $pdf->Cell(0, 5, ''); // Avanzar línea para posicionar
    $texto6a = mb_convert_encoding("Acepto los Terminos y Condiciones del contrato de Viaje Publicado en la pagina Web", 'ISO-8859-1');
    $texto6b = mb_convert_encoding("www.supersemria.com, Representacion Impresa del Comprobante Electronico", 'ISO-8859-1');
    $pdf->SetFont('Arial', '', 6); // Texto negrita
    $ancho_texto = $pdf->GetStringWidth($texto6a);
    $x = (90 - $ancho_texto) / 2;
    $pdf->SetX($x);
    $pdf->Write(3, $texto6a);
    $pdf->SetFont('Arial', '', 6); // Texto normal
    $pdf->Write(3, $texto6b);

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto6c = mb_convert_encoding("", 'ISO-8859-1');
    $texto6d = ' ';
    $pdf->SetFont('Arial', '', 7); // Texto negrita
    $pdf->Write(5.5, $texto6c);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(4, $texto6d);
    $pdf->SetDrawColor(0, 0, 0);
    $pdf->Line(0, $pdf->GetY(), 200, $pdf->GetY());

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto6e = mb_convert_encoding("AGRADECEMOS SU PREFERENCIA VUELVA PRONTO!!!", 'ISO-8859-1');
    $texto6f = ' ';
    $pdf->SetFont('Arial', '', 7); // Texto negrita
    $pdf->Write(3, $texto6e);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(3, $texto6f);
    $pdf->Image('img/barcode.png', 30, 215, 20); //logo de la empresa,moverDerecha,moverAbajo,tamañoIMG

    //--------CUERPO 7 TEXT7--------//
    $pdf->Ln(27);
    $pdf->Line(0, $pdf->GetY(), 200, $pdf->GetY());
    $pdf->Ln(3);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(4, 1, mb_convert_encoding("SUPER SEMERIA S.A.", 'ISO-8859-1'), 0, 0, '', 0);
    $pdf->SetFont('Arial', '', 6);
    $pdf->Cell(0, 4, ''); // Avanzar línea para posicionar
    $texto7a = mb_convert_encoding("RUTA :", 'ISO-8859-1');
    $texto7b = ' ' . $salidaz . ' - ' . $llegadaz;
    $pdf->Write(4, $texto7a);
    $pdf->Write(4, $texto7b);

    $pdf->Cell(0, 4, ''); // Avanzar línea para posicionar
    $texto7c = mb_convert_encoding("VENDIDO POR :", 'ISO-8859-1');
    $texto7d = ' ' . $_SESSION['correo'];
    $pdf->Write(4, $texto7c);
    $pdf->Write(4, $texto7d);

    $pdf->Cell(0, 4, ''); // Avanzar línea para posicionar
    $texto7e = mb_convert_encoding("FECHA Y HORA :", 'ISO-8859-1');
    $texto7f = ' ' . $salidaz . ' - ' . $tiempoz;
    $pdf->Write(4, $texto7e);
    $pdf->Write(4, $texto7f);

    $pdf->Cell(0, 4, ''); // Avanzar línea para posicionar
    $texto7g = mb_convert_encoding("PASAJERO :", 'ISO-8859-1');
    $texto7h = ' ' . $choferez2;
    $pdf->Write(4, $texto7g);
    $pdf->Write(4, $texto7h);

    $pdf->Cell(0, 4, ''); // Avanzar línea para posicionar
    $texto7i = mb_convert_encoding("BOLETO Y N°ASIENTO :", 'ISO-8859-1');
    $texto7j = ' ' . $termsal8 . ' - ' . $termsal3;
    $pdf->Write(4, $texto7i);
    $pdf->Write(4, $texto7j);

    $pdf->Cell(0, 4, ''); // Avanzar línea para posicionar
    $texto7k = mb_convert_encoding("TOTAL S/:", 'ISO-8859-1');
    $texto7l = ' ' . $termsal6;
    $pdf->Write(4, $texto7k);
    $pdf->Write(4, $texto7l);
    $pdf->Ln(4);
    $pdf->Line(0, $pdf->GetY(), 200, $pdf->GetY());
    //------------------------------//

    $pdf->SetFont('Arial', '', 7);
    $pdf->Ln();
    $pdf->Ln(2);
    $pdf->SetFont('Arial', '', 8);
    // Mostrar el PDF en el navegador
    $pdf->Output('I', "ticket_{$termsal8}.pdf");
} else {
    die("Venta no encontrada.");
}
$conn->close();
