<?php
include 'conexioon.php';
require 'fpdf/fpdf.php';

$num_docpe = $_GET['id'];
$tipo = $_GET['tipo'];
$tipoDoc = substr($tipo, 0, 1); // muestra el primer carácter;

function numero_a_letras($numero)
{
    $unidades = ['', 'UNO', 'DOS', 'TRES', 'CUATRO', 'CINCO', 'SEIS', 'SIETE', 'OCHO', 'NUEVE'];
    $decenas = ['', 'DIEZ', 'VEINTE', 'TREINTA', 'CUARENTA', 'CINCUENTA', 'SESENTA', 'SETENTA', 'OCHENTA', 'NOVENTA'];
    $centenas = ['', 'CIEN', 'DOSCIENTOS', 'TRESCIENTOS', 'CUATROCIENTOS', 'QUINIENTOS', 'SEISCIENTOS', 'SETECIENTOS', 'OCHOCIENTOS', 'NOVECIENTOS'];
    $especiales = [
        11 => 'ONCE',
        12 => 'DOCE',
        13 => 'TRECE',
        14 => 'CATORCE',
        15 => 'QUINCE',
        16 => 'DIECISÉIS',
        17 => 'DIECISIETE',
        18 => 'DIECIOCHO',
        19 => 'DIECINUEVE',
        21 => 'VEINTIUNO',
        22 => 'VEINTIDÓS',
        23 => 'VEINTITRÉS',
        24 => 'VEINTICUATRO',
        25 => 'VEINTICINCO',
        26 => 'VEINTISÉIS',
        27 => 'VEINTISIETE',
        28 => 'VEINTIOCHO',
        29 => 'VEINTINUEVE'
    ];
    if (!is_numeric($numero)) {
        return "ERROR: NO ES UN NÚMERO VÁLIDO";
    }
    $numero = number_format($numero, 2, '.', '');
    list($entero, $decimal) = explode('.', $numero);
    $entero = (int) $entero;
    $decimal = (int) $decimal;
    if ($entero == 0) {
        $resultado = "CERO";
    } else {
        $resultado = convertirNumero($entero, $unidades, $decenas, $centenas, $especiales);
    }
    // Manejo de decimales en formato /100 SOLES
    $decimalStr = str_pad($decimal, 2, "0", STR_PAD_LEFT);
    $resultado .= " CON " . $decimalStr . "/100 SOLES";
    return $resultado;
}
function convertirNumero($numero, $unidades, $decenas, $centenas, $especiales)
{
    if ($numero < 10) {
        return $unidades[$numero];
    } elseif (isset($especiales[$numero])) {
        return $especiales[$numero];
    } elseif ($numero < 100) {
        $decena = (int) ($numero / 10);
        $unidad = $numero % 10;
        return $decenas[$decena] . ($unidad > 0 ? " Y " . $unidades[$unidad] : "");
    } elseif ($numero < 1000) {
        $centena = (int) ($numero / 100);
        $resto = $numero % 100;
        if ($numero == 100) {
            return "CIEN"; // Corregido para que no diga "UNA CIEN"
        }
        return $centenas[$centena] . ($resto > 0 ? " " . convertirNumero($resto, $unidades, $decenas, $centenas, $especiales) : "");
    } elseif ($numero < 1000000) {
        $miles = (int) ($numero / 1000);
        $resto = $numero % 1000;
        return ($miles == 1 ? "MIL" : convertirNumero($miles, $unidades, $decenas, $centenas, $especiales) . " MIL") .
            ($resto > 0 ? " " . convertirNumero($resto, $unidades, $decenas, $centenas, $especiales) : "");
    } elseif ($numero < 1000000000) {
        $millones = (int) ($numero / 1000000);
        $resto = $numero % 1000000;
        return ($millones == 1 ? "UN MILLÓN" : convertirNumero($millones, $unidades, $decenas, $centenas, $especiales) . " MILLONES") .
            ($resto > 0 ? " " . convertirNumero($resto, $unidades, $decenas, $centenas, $especiales) : "");
    } else {
        return "NÚMERO FUERA DE RANGO";
    }
}

// Obtener datos de la venta
$sql = "SELECT * FROM ventas WHERE id = '$num_docpe'";
$result = $conn->query($sql);
$venta = $result->fetch_assoc();

// Obtener detalle de la venta
$sql_detalle = "SELECT p.descripcion, d.cantidad, d.precio, (d.cantidad * d.precio) AS subtotal 
                FROM detalle_ventas d
                JOIN producto p ON d.id_producto = p.codproducto
                WHERE d.id_venta = '$num_docpe'";
$result_detalle = $conn->query($sql_detalle);

// Si es boleta, nota de venta imprimir en ticketera
if ($tipoDoc == "B") {
    $pdf = new FPDF('P', 'mm', array(80, 300)); // Ticket pequeño
    $pdf->AddPage();
    $pdf->SetMargins(0, 0, 0);
    $pdf->SetFont('Arial', 'B', 9);
    // **📌 CABECERA DEL DOCUMENTO**
    // Agregar logo
    $pdf->SetFont('Times', 'B', 9);
    $pdf->Image('img/logo.png', 1, 2, 30); //logo de la empresa,moverDerecha,moverAbajo,tamañoIMG
    $pdf->SetFont('Arial', 'B', 9); //tipo fuente, negrita(B-I-U-BIU), tamañoTexto
    $pdf->ln(-15); // Movernos a la derecha
    $pdf->Cell(25); // Movernos a la derecha
    $pdf->SetTextColor(0, 0, 0); //color
    $pdf->Cell(49, 50, 'R.U.C. 20608279718', 0, 1, 'C', 0);
    $pdf->Ln(-22);
    /* RUC */
    $pdf->Cell(20);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell(70, -28, mb_convert_encoding("YOVERA CORP E.I.R.L", 'ISO-8859-1'), 0, 0, 'C', 0);
    $pdf->Ln(1);
    $pdf->SetFont('Arial', '', 6);
    //$pdf->Cell(63, -20, mb_convert_encoding("DE : RUIZ CARDOZO MARIO", 'ISO-8859-1'), 0, 0, 'R', 0);
    $pdf->Ln(-1);
    $pdf->Cell(25);  // mover a la derecha
    $pdf->SetFont('Arial', '', 6);
    $pdf->MultiCell(57, 4, mb_convert_encoding("GALILEA1 PUERTAS DEL SOL MR LT-13 LAMBAYEQUE - CHICLAYO - CHICLAYO", 'ISO-8859-1'), 0, 'C');
    $pdf->Ln(2);
    $pdf->Cell(8);  // mover a la derecha
    $pdf->SetFont('Arial', '', 7);
    $pdf->Cell(60, -1, mb_convert_encoding("Telefono : (+51) 915 126 870", 'ISO-8859-1'), 0, 0, 'R', 0);
    $pdf->Ln(5);
    /*DOCUMENTO*/
    $pdf->SetFont('Arial', 'B', 9);
    $pdf->Cell(0, 5, mb_convert_encoding("BOLETA DE VENTA ELECTRONICA", 'ISO-8859-1'), 0, 0, 'C', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Ln(-1);
    $pdf->Cell(25);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(1, 15, mb_convert_encoding($venta['num_docpe'], 'ISO-8859-1'), 0, 0, 'L', 0);
    $pdf->Ln(2);
    $pdf->SetDrawColor(0, 0, 0);
    $pdf->Ln(10);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->Ln(-5);
    // **📌 Información del Cliente**
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, ''); // Avanzar línea para posicionar
    $texto1a = mb_convert_encoding("Fecha de Emisión :", 'ISO-8859-1');
    $texto1b = ' ' . $venta['fecha'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5, $texto1a);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5, $texto1b);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, ''); // Avanzar línea para posicionar
    $texto1c = mb_convert_encoding("Cliente : ", 'ISO-8859-1');
    $texto1d = ' ' . $venta['cliente'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5, $texto1c);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5, $texto1d);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto1e = mb_convert_encoding("Dirección :", 'ISO-8859-1');
    $texto1f = ' ' . $venta['direccion'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5.5, $texto1e);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5.5, $texto1f);
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto1ae = mb_convert_encoding("D.N.I. : ", 'ISO-8859-1');
    $texto1af = ' ' . $venta['doc_ident'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5.5, $texto1ae);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5.5, $texto1af);
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto1g = mb_convert_encoding("Forma de Pago :", 'ISO-8859-1');
    $texto1h = ' ' . $venta['metodo'];
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5.5, $texto1g);
    $pdf->SetFont('Arial', '', 8); // Texto normal
    $pdf->Write(5.5, $texto1h);
    $pdf->Ln(5);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    // **📌 TABLA DE DETALLES**
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(20, 5, "Cant - Precio", 0, 0, 'C');
    $pdf->Cell(40, 5, "Producto", 0, 0, 'C');
    $pdf->Cell(20, 5, "Total", 0, 0, 'L');
    $pdf->Ln(5);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->Ln(1);
    $pdf->SetFont('Arial', '', 8);
    $total = 0;
    while ($row = $result_detalle->fetch_assoc()) {
        $subtotal = $row['cantidad'] * $row['precio'];
        $total += $subtotal;
        $pdf->Cell(20, 5, $row['cantidad'] . ' x ' . $row['precio'], 0, 0, 'C');
        $pdf->MultiCell(50, 5, $row['descripcion'], 0, 'L');
        $pdf->Cell(80, 5, '                                                SubTotal S/.  ' . number_format($row['cantidad'] * $row['precio'], 2), 0, 1, 'C');
    }
    $pdf->Ln(2);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    // **📌 TOTAL**
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(50, 6, "TOTAL:", 0, 0, 'R');
    $pdf->Cell(20, 6, "S/ " . number_format($total, 2, '.', ','), 0, 0, 'R');
    $pdf->Ln(3);
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto5g = mb_convert_encoding("SON :", 'ISO-8859-1');
    $total_venta = $total;
    $total_venta_letras = ' ' . numero_a_letras($total_venta);
    $pdf->SetFont('Arial', 'B', 7); // Texto negrita
    $pdf->Write(4.5, $texto5g);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(4.5, strtoupper($total_venta_letras));
    $pdf->Ln(4);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto6e = mb_convert_encoding("AGRADECEMOS SU PREFERENCIA VUELVA PRONTO!!!", 'ISO-8859-1');
    $texto6f = ' ';
    $pdf->SetFont('Arial', '', 7); // Texto negrita
    $pdf->Write(3, $texto6e);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(3, $texto6f);
    $posY = $pdf->GetY() + 5; // Ajusta la posición en función del contenido
    $pdf->Image('img/barcode.png', 27, $posY, 28); //logo de la empresa,moverDerecha,moverAbajo,tamañoIMG
    // **📌 Salida del PDF**
    $pdf->Output("I", $venta['num_docpe'] . ".pdf");
}

if ($tipoDoc == "N") {
    $pdf = new FPDF('P', 'mm', array(80, 300)); // Ticket pequeño
    $pdf->AddPage();
    $pdf->SetMargins(5, 5, 5);
    $pdf->SetFont('Arial', 'B', 9);
    // **📌 CABECERA DEL DOCUMENTO**
    // Agregar logo
    $pdf->SetFont('Times', 'B', 9);
    $pdf->Image('img/logo.png', 1, 2, 30); //logo de la empresa,moverDerecha,moverAbajo,tamañoIMG
    $pdf->SetFont('Arial', 'B', 10); //tipo fuente, negrita(B-I-U-BIU), tamañoTexto
    $pdf->ln(-15); // Movernos a la derecha
    $pdf->Cell(25); // Movernos a la derecha
    $pdf->SetTextColor(0, 0, 0); //color
    $pdf->Cell(38, 50, 'R.U.C. 20608279718', 0, 1, 'C', 0);
    $pdf->Ln(-22);
    /* RUC */
    $pdf->Cell(20);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell(55, -28, mb_convert_encoding("YOVERA CORP E.I.R.L", 'ISO-8859-1'), 0, 0, 'R', 0);
    $pdf->Ln(1);
    $pdf->SetFont('Arial', '', 7);
    //$pdf->Cell(63, -20, mb_convert_encoding("DE : RUIZ CARDOZO MARIO", 'ISO-8859-1'), 0, 0, 'R', 0);
    $pdf->Ln(1);
    $pdf->Cell(8);  // mover a la derecha
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(53, -1, mb_convert_encoding("Telefono : (+51) 915 126 870", 'ISO-8859-1'), 0, 0, 'R', 0);
    $pdf->Ln(3);
    /*DOCUMENTO*/
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(0, 5, mb_convert_encoding("NOTA DE VENTA", 'ISO-8859-1'), 0, 0, 'C', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Ln(-1);
    $pdf->Cell(25);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 9);
    $pdf->Cell(1, 15, mb_convert_encoding($venta['num_docpe'], 'ISO-8859-1'), 0, 0, 'L', 0);
    $pdf->Ln(2);
    $pdf->SetDrawColor(0, 0, 0);
    $pdf->Ln(10);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->Ln(-5);
    // **📌 Información del Cliente**
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, ''); // Avanzar línea para posicionar
    $texto1a = mb_convert_encoding("Fecha de Emisión :", 'ISO-8859-1');
    $texto1b = ' ' . $venta['fecha'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5, $texto1a);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5, $texto1b);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, ''); // Avanzar línea para posicionar
    $texto1c = mb_convert_encoding("Cliente : ", 'ISO-8859-1');
    $texto1d = ' ' . $venta['cliente'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5, $texto1c);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5, $texto1d);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto1e = mb_convert_encoding("Dirección :", 'ISO-8859-1');
    $texto1f = ' ' . $venta['direccion'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5.5, $texto1e);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5.5, $texto1f);
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto1g = mb_convert_encoding("Forma de Pago :", 'ISO-8859-1');
    $texto1h = ' ' . $venta['metodo'];
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5.5, $texto1g);
    $pdf->SetFont('Arial', '', 8); // Texto normal
    $pdf->Write(5.5, $texto1h);
    $pdf->Ln(5);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    // **📌 TABLA DE DETALLES**
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(20, 5, "Cant - Precio", 0, 0, 'C');
    $pdf->Cell(40, 5, "Producto", 0, 0, 'C');
    $pdf->Cell(20, 5, "Total", 0, 0, 'L');
    $pdf->Ln(5);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->Ln(1);
    $pdf->SetFont('Arial', '', 8);
    $total = 0;
    while ($row = $result_detalle->fetch_assoc()) {
        $subtotal = $row['cantidad'] * $row['precio'];
        $total += $subtotal;
        $pdf->Cell(20, 5, $row['cantidad'] . ' x ' . $row['precio'], 0, 0, 'C');
        $pdf->MultiCell(50, 5, $row['descripcion'], 0, 'L');
        $pdf->Cell(80, 5, '                                                 SubTotal S/.  ' . number_format($row['cantidad'] * $row['precio'], 2), 0, 1, 'C');
    }
    $pdf->Ln(2);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    // **📌 TOTAL**
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(50, 6, "TOTAL:", 0, 0, 'R');
    $pdf->Cell(20, 6, "S/ " . number_format($total, 2, '.', ','), 0, 0, 'R');
    $pdf->Ln(3);
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto5g = mb_convert_encoding("SON :", 'ISO-8859-1');
    $total_venta = $total;
    $total_venta_letras = ' ' . numero_a_letras($total_venta);
    $pdf->SetFont('Arial', 'B', 7); // Texto negrita
    $pdf->Write(4.5, $texto5g);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(4.5, strtoupper($total_venta_letras));
    $pdf->Ln(4);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto6e = mb_convert_encoding("AGRADECEMOS SU PREFERENCIA VUELVA PRONTO!!!", 'ISO-8859-1');
    $texto6f = ' ';
    $pdf->SetFont('Arial', '', 7); // Texto negrita
    $pdf->Write(3, $texto6e);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(3, $texto6f);
    // **📌 Salida del PDF**
    $pdf->Output("I", $venta['num_docpe'] . ".pdf");
}

if ($tipoDoc == "T") {
    $pdf = new FPDF('P', 'mm', 'A4'); // Factura en tamaño A4
    $pdf->AddPage();
    $pdf->SetMargins(5, 5, 5);
    $pdf->SetFont('Arial', 'B', 9);
    // **📌 CABECERA DEL DOCUMENTO**
    // Agregar logo
    $pdf->SetFont('Times', 'B', 11);
    $pdf->Image('img/logo.png', 5, 1, 35); //logo de la empresa,moverDerecha,moverAbajo,tamañoIMG
    $pdf->SetFont('Arial', 'B', 12); //tipo fuente, negrita(B-I-U-BIU), tamañoTexto
    $pdf->ln(-5); // Movernos a la derecha
    $pdf->Cell(150); // Movernos a la derecha
    $pdf->SetTextColor(0, 0, 0); //color
    $pdf->Cell(0, 12, mb_convert_encoding('R.U.C. N° 20608279718', 'ISO-8859-1'), 1, 0, 'C', 0);
    $pdf->Ln(7);
    /* RUC */
    $pdf->Cell(20);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 16);
    $pdf->Cell(15);  // mover a la derecha
    $pdf->Cell(80, -5, mb_convert_encoding("YOVERA CORP E.I.R.L", 'ISO-8859-1'), 0, 0, 'L', 0);
    $pdf->SetFont('Arial', '', 7);
    $pdf->Ln(1);
    $pdf->Cell(70, 4, mb_convert_encoding("DE : RUIZ CARDOZO MARIO", 'ISO-8859-1'), 0, 0, 'R', 0);
    $pdf->Ln(4.5);
    $pdf->Cell(35);  // mover a la derecha
    $pdf->SetFont('Arial', '', 7);
    $pdf->MultiCell(120, 4, mb_convert_encoding("OFICINA.: AV.BALTA 1414 TDA-116 GALER IVANLIKAN (1ER PISO) LAMBAYEQUE - CHICLAYO - CHICLAYO ", 'ISO-8859-1'), 0, 'L');
    $pdf->Ln(-1.2);
    $pdf->Cell(15);  // mover a la derecha
    $pdf->Cell(50, 6, mb_convert_encoding("Telefono : (+51) 915 126 870", 'ISO-8859-1'), 0, 0, 'R', 0);
    /*DOCUMENTO*/
    $pdf->SetFont('Arial', 'B', 11);
    $pdf->Ln(-7.3);
    $pdf->Cell(150);  // mover a la derecha
    $pdf->SetFillColor(169, 169, 169);
    $pdf->Cell(50, 5, mb_convert_encoding("FACTURA ELECTRONICA", 'ISO-8859-1'), 1, 1, 'C', 1);
    $pdf->SetFont('Arial', '', 10);
    $pdf->Ln(-0.1);
    $pdf->Cell(150);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->SetTextColor(255, 0, 0); // Rojo (Texto)
    $pdf->Cell(0, 7, mb_convert_encoding($venta['num_docpe'], 'ISO-8859-1'), 1, 0, 'C', 0);
    $pdf->Ln(2);
    $pdf->SetTextColor(0, 0, 0); // Rojo (Texto)
    $pdf->SetDrawColor(0, 0, 0);
    $pdf->Ln(13);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->Ln(-5);
    // **📌 Información del Cliente**
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, ''); // Avanzar línea para posicionar
    $texto1a = mb_convert_encoding("Fecha de Emisión :", 'ISO-8859-1');
    $texto1b = ' ' . $venta['fecha'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5, $texto1a);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5, $texto1b);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, ''); // Avanzar línea para posicionar
    $texto1a = mb_convert_encoding("R.U.C. :", 'ISO-8859-1');
    $texto1b = ' ' . $venta['doc_ident'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5, $texto1a);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5, $texto1b);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, ''); // Avanzar línea para posicionar
    $texto1c = mb_convert_encoding("SEÑOR(ES) : ", 'ISO-8859-1');
    $texto1d = ' ' . $venta['cliente'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5, $texto1c);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5, $texto1d);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto1e = mb_convert_encoding("DOMICILIO FISCAL :", 'ISO-8859-1');
    $texto1f = ' ' . $venta['direccion'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5.5, $texto1e);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5.5, $texto1f);
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto1g = mb_convert_encoding("FORMA DE PAGO :", 'ISO-8859-1');
    $texto1h = ' ' . $venta['metodo'];
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5.5, $texto1g);
    $pdf->SetFont('Arial', '', 8); // Texto normal
    $pdf->Write(5.5, $texto1h);
    $pdf->Ln(5);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->Ln(2);
    // **📌 TABLA DE DETALLES**
    $pdf->SetFont('Arial', 'B', 9);
    $pdf->SetFillColor(221, 221, 221);
    $pdf->Cell(90, 5, "Producto", 0, 0, 'C', 1);
    $pdf->Cell(40, 5, "Cantidad", 0, 0, 'C', 1);
    $pdf->Cell(30, 5, "P.Unitario", 0, 0, 'C', 1);
    $pdf->Cell(35, 5, "Total", 0, 0, 'C', 1);
    $pdf->Ln(5);
    $pdf->SetFont('Arial', '', 8);
    $total = 0;
    while ($row = $result_detalle->fetch_assoc()) {
        $subtotal = $row['cantidad'] * $row['precio'];
        $total += $subtotal;
        $pdf->Cell(90, 5, $row['descripcion'], 0, 0, 'L');
        $pdf->Cell(40, 5, $row['cantidad'], 0, 0, 'C');
        $pdf->Cell(30, 5, $row['precio'], 0, 0, 'R');
        $pdf->Cell(30, 5, number_format($row['cantidad'] * $row['precio'], 2), 0, 1, 'R');
    }
    $pdf->Ln(2);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());

    // **📌 SUB-TOTAL**
    $subtotal = $total / 1.18;  // Calcular subtotal antes de IGV
    $igv = $total - $subtotal;
    $pdf->SetDrawColor(0, 0, 0);
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Ln(2);
    $texto5a = mb_convert_encoding("Op. No Gravada :", 'ISO-8859-1');
    $pdf->SetFont('Arial', 'B', 9); // Texto negrita
    $pdf->Cell(150);  // mover a la derecha
    $pdf->Cell(25, 5, $texto5a, 0, 0, 'L');
    $pdf->SetFont('Arial', 'B', 9); // Texto normal
    $pdf->Cell(20, 5, "S/ " . number_format($subtotal, 2, '.', ','), 0, 0, 'R');

    // **📌 IGV**
    $pdf->SetFont('Arial', 'B', 9); // Negrita
    $pdf->Ln(8);
    $texto5c = mb_convert_encoding("I.G.V.(18.00%)    :", 'ISO-8859-1');
    $pdf->SetFont('Arial', 'B', 9); // Texto negrita
    $pdf->Cell(150);  // mover a la derecha
    $pdf->Cell(25, 5, $texto5c, 0, 0, 'L');
    $pdf->SetFont('Arial', 'B', 9); // Texto normal
    $pdf->Cell(20, 5, "S/ " . number_format($igv, 2, '.', ','), 0, 0, 'R');

    // **📌 TOTAL**
    $pdf->SetFont('Arial', 'B', 9);
    $pdf->Ln(8);
    $pdf->Cell(125);  // mover a la derecha
    $pdf->Cell(50, 6, "                         IMPORTE TOTAL :", 0, 0, 'L');
    $pdf->Cell(20, 6, "S/ " . number_format($total, 2, '.', ','), 0, 0, 'R');
    $pdf->Ln(8);
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    //$pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto5g = mb_convert_encoding("SON :", 'ISO-8859-1');
    $total_venta = $total;
    $total_venta_letras = ' ' . numero_a_letras($total_venta);
    $pdf->SetFont('Arial', 'B', 9); // Texto negrita
    $pdf->Cell(40);
    $pdf->Write(4.5, $texto5g);
    $pdf->SetFont('Arial', '', 9); // Texto normal
    $pdf->Ln(0);
    $pdf->Cell(50);
    $pdf->Write(4.5, strtoupper($total_venta_letras));
    $pdf->Ln(6);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Ln(5);
    $pdf->Cell(70, 7, ''); // Avanzar línea para posicionar
    $texto6e = mb_convert_encoding("AGRADECEMOS SU PREFERENCIA VUELVA PRONTO!!!", 'ISO-8859-1');
    $texto6f = ' ';
    $pdf->SetFont('Arial', '', 7); // Texto negrita
    $pdf->Write(3, $texto6e);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(3, $texto6f);
    $pdf->Ln(2);
    //Agregar la imagen justo después del detalle
    $posY = $pdf->GetY() - 36; // Ajusta la posición en función del contenido
    $pdf->Image('img/barcode.png', 10, $posY, 28); //logo de la empresa,moverDerecha,moverAbajo,tamañoIMG

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Ln(2);
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto1g = mb_convert_encoding("  Sirvase Abonar ala Cuenta de YOVERA CORP E.I.R.L", 'ISO-8859-1');
    $texto2g = 'BCP                 SOLES 0000000000000';
    $pdf->SetFont('Arial', '', 7); // Texto negrita
    $pdf->Write(3, $texto1g);
    $pdf->Ln(4);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    //$pdf->Write(3, $texto2g);

    // Definir número de cuenta
    $numeroCuenta = 'BCP     SOLES   0000000000000';
    // Posición y tamaño del cuadro
    $x = 6;
    $y = 127;
    $width = 80;
    $height = 15;

    // Dibujar el rectángulo
    $pdf->Rect($x, $y, $width, $height, 'L');

    // Agregar número de cuenta dentro del cuadro
    $pdf->SetXY($x, $y + 4);
    $pdf->SetFont('helvetica', 'B', 10);
    $pdf->Cell($width, 10, $numeroCuenta, 0, 1, 'L');

    // **📌 Salida del PDF**
    $pdf->Output("I", $venta['num_docpe'] . ".pdf");
}

if ($tipoDoc == "F") {
    $pdf = new FPDF('P', 'mm', array(80, 300)); // Ticket pequeño
    $pdf->AddPage();
    $pdf->SetMargins(0, 0, 0);
    $pdf->SetFont('Arial', 'B', 9);
    // **📌 CABECERA DEL DOCUMENTO**
    // Agregar logo
    $pdf->SetFont('Times', 'B', 9);
    $pdf->Image('img/logo.png', 1, 4, 30); //logo de la empresa,moverDerecha,moverAbajo,tamañoIMG
    $pdf->SetFont('Arial', 'B', 9); //tipo fuente, negrita(B-I-U-BIU), tamañoTexto
    $pdf->ln(-15); // Movernos a la derecha
    $pdf->Cell(25); // Movernos a la derecha
    $pdf->SetTextColor(0, 0, 0); //color
    $pdf->Cell(49, 50, 'R.U.C. 20608279718', 0, 1, 'C', 0);
    $pdf->Ln(-22);
    /* RUC */
    $pdf->Cell(20);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 11);
    $pdf->Cell(60, -28, mb_convert_encoding("YOVERA CORP E.I.R.L", 'ISO-8859-1'), 0, 0, 'C', 0);
    $pdf->Ln(1);
    $pdf->SetFont('Arial', '', 6);
    $pdf->Cell(63, -20, mb_convert_encoding("DE : RUIZ CARDOZO MARIO", 'ISO-8859-1'), 0, 0, 'R', 0);
    $pdf->Ln(-1);
    $pdf->Cell(25);  // mover a la derecha
    $pdf->SetFont('Arial', '', 6);
    $pdf->MultiCell(57, 4, mb_convert_encoding("GALILEA1 PUERTAS DEL SOL MR LT-13 LAMBAYEQUE - CHICLAYO - CHICLAYO", 'ISO-8859-1'), 0, 'C');
    $pdf->Ln(2);
    $pdf->Cell(8);  // mover a la derecha
    $pdf->SetFont('Arial', '', 7);
    $pdf->Cell(60, -1, mb_convert_encoding("Telefono : (+51) 915 126 870", 'ISO-8859-1'), 0, 0, 'R', 0);
    $pdf->Ln(5);
    /*DOCUMENTO*/
    $pdf->SetFont('Arial', 'B', 9);
    $pdf->Cell(0, 5, mb_convert_encoding("FACTURA ELECTRONICA", 'ISO-8859-1'), 0, 0, 'C', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Ln(-1);
    $pdf->Cell(25);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(1, 15, mb_convert_encoding($venta['num_docpe'], 'ISO-8859-1'), 0, 0, 'L', 0);
    $pdf->Ln(2);
    $pdf->SetDrawColor(0, 0, 0);
    $pdf->Ln(10);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->Ln(-5);
    // **📌 Información del Cliente**
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, ''); // Avanzar línea para posicionar
    $texto1a = mb_convert_encoding("Fecha de Emisión :", 'ISO-8859-1');
    $texto1b = ' ' . $venta['fecha'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5, $texto1a);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5, $texto1b);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, ''); // Avanzar línea para posicionar
    $texto1c = mb_convert_encoding("Señor(es) : ", 'ISO-8859-1');
    $texto1d = ' ' . $venta['cliente'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5, $texto1c);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5, $texto1d);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto1e = mb_convert_encoding("Dirección : ", 'ISO-8859-1');
    $texto1af = ' ' . $venta['direccion'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5.5, $texto1e);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5.5, $texto1af);
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar

    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto1e = mb_convert_encoding("R.U.C. : ", 'ISO-8859-1');
    $texto1f = ' ' . $venta['doc_ident'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5.5, $texto1e);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5.5, $texto1f);
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar

    $texto1g = mb_convert_encoding("Forma de Pago :", 'ISO-8859-1');
    $texto1h = ' ' . $venta['metodo'];
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5.5, $texto1g);
    $pdf->SetFont('Arial', '', 8); // Texto normal
    $pdf->Write(5.5, $texto1h);
    $pdf->Ln(5);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    // **📌 TABLA DE DETALLES**
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(20, 5, "Cant - Precio", 0, 0, 'C');
    $pdf->Cell(40, 5, "Producto", 0, 0, 'C');
    $pdf->Cell(20, 5, "Total", 0, 0, 'L');
    $pdf->Ln(5);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->Ln(1);
    $pdf->SetFont('Arial', '', 8);
    $total = 0;
    while ($row = $result_detalle->fetch_assoc()) {
        $subtotal = $row['cantidad'] * $row['precio'];
        $total += $subtotal;
        $pdf->Cell(20, 5, $row['cantidad'] . ' x ' . $row['precio'], 0, 0, 'C');
        $pdf->MultiCell(50, 5, $row['descripcion'], 0, 'L');
        $pdf->Cell(80, 5, '                                                SubTotal S/.  ' . number_format($row['cantidad'] * $row['precio'], 2), 0, 1, 'C');
    }
    $pdf->Ln(2);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());

    // **📌 SUB-TOTAL**
    $subtotal = $total / 1.18;  // Calcular subtotal antes de IGV
    $igv = $total - $subtotal;
    $pdf->SetFont('Arial', '', 9);
    $pdf->Cell(50, 6, "Op. No Gravada S/ :", 0, 0, 'R');
    $pdf->Cell(20, 6, "   " . number_format($subtotal, 2, '.', ','), 0, 0, 'R');
    $pdf->Ln(4);

    // **📌 IGV**
    $pdf->SetFont('Arial', '', 9);
    $pdf->Cell(50, 6, "I.G.V.(18.00%) S/ :", 0, 0, 'R');
    $pdf->Cell(20, 6, "   " . number_format($igv, 2, '.', ','), 0, 0, 'R');
    $pdf->Ln(5);

    // **📌 TOTAL**
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(50, 6, "Total S/ :", 0, 0, 'R');
    $pdf->Cell(20, 6, "   " . number_format($total, 2, '.', ','), 0, 0, 'R');
    $pdf->Ln(3);

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto5g = mb_convert_encoding("SON :", 'ISO-8859-1');
    $total_venta = $total;
    $total_venta_letras = ' ' . numero_a_letras($total_venta);
    $pdf->SetFont('Arial', 'B', 7); // Texto negrita
    $pdf->Write(4.5, $texto5g);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(4.5, strtoupper($total_venta_letras));
    $pdf->Ln(4);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto6e = mb_convert_encoding("AGRADECEMOS SU PREFERENCIA VUELVA PRONTO!!!", 'ISO-8859-1');
    $texto6f = ' ';
    $pdf->SetFont('Arial', '', 7); // Texto negrita
    $pdf->Write(3, $texto6e);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(3, $texto6f);
    $posY = $pdf->GetY() + 5; // Ajusta la posición en función del contenido
    $pdf->Image('img/barcode.png', 27, $posY, 28); //logo de la empresa,moverDerecha,moverAbajo,tamañoIMG
    // **📌 Salida del PDF**
    $pdf->Output("I", $venta['num_docpe'] . ".pdf");
}

?>