<?php
session_start();
require 'conexiom.php';

$id_venta = $_POST['id_venta'];

$sql = "SELECT id, cliente, total, metodo FROM ventas WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id_venta);
$stmt->execute();
$result = $stmt->get_result();
$venta = $result->fetch_assoc();

$sql_detalle = "SELECT dv.id_producto, p.descripcion AS producto, dv.cantidad, dv.precio, p.presentacion 
                FROM detalle_ventas dv 
                JOIN producto p ON dv.id_producto = p.codproducto 
                WHERE dv.id_venta = ?";
$stmt_detalle = $conn->prepare($sql_detalle);
$stmt_detalle->bind_param("i", $id_venta);
$stmt_detalle->execute();
$result_detalle = $stmt_detalle->get_result();
$detalle = [];
while ($row = $result_detalle->fetch_assoc()) {
    $detalle[] = $row;
}

echo json_encode(["venta" => $venta, "detalle" => $detalle]);
?>