<?php
// Iniciar sesión solo si es necesario
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// Conexión directa a la base de datos (temporal)
$host = "localhost";
$user = "yoveraes_userdb";
$pass = "t7@s5FxYn1GB";
$dbname = "yoveraes_botica";

$conn = new mysqli($host, $user, $pass, $dbname);

if ($conn->connect_error) {
    die("<div style='padding: 20px; background: #ffebee; color: #c62828; border-radius: 5px;'>
            <h3>Error de conexión a la base de datos</h3>
            <p><strong>Error:</strong> " . $conn->connect_error . "</p>
            <p>Verifica la configuración en kardex.php</p>
        </div>");
}

// Verificar si las tablas existen
$tablas = ['producto', 'compras', 'detalle_compras', 'ventas', 'detalle_ventas'];
foreach ($tablas as $tabla) {
    $result = $conn->query("SHOW TABLES LIKE '$tabla'");
    if ($result->num_rows == 0) {
        die("<div style='padding: 20px; background: #fff3e0; color: #ef6c00; border-radius: 5px;'>
                <h3>Tabla no encontrada</h3>
                <p>La tabla <strong>$tabla</strong> no existe en la base de datos.</p>
                <p>Ejecuta el archivo SQL de estructura primero.</p>
            </div>");
    }
}

// Función para buscar productos
function buscarProductos($conn, $termino)
{
    $query = "SELECT codproducto, codigo, descripcion, precio, existencia 
              FROM producto 
              WHERE (codigo LIKE ? OR descripcion LIKE ?) 
              AND estado = 1 
              ORDER BY descripcion 
              LIMIT 10";

    $termino = "%" . $termino . "%";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ss", $termino, $termino);
    $stmt->execute();

    return $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}

// Procesar búsqueda
$productos = [];
$resultado_kardex = null;
$termino_busqueda = '';
$id_producto_actual = 0;

if (isset($_GET['buscar']) && !empty($_GET['buscar'])) {
    $termino_busqueda = trim($_GET['buscar']);
    $productos = buscarProductos($conn, $termino_busqueda);
}

// Procesar generación de kardex
if (isset($_GET['id_producto']) && !empty($_GET['id_producto'])) {
    $id_producto_actual = intval($_GET['id_producto']);
    $fecha_inicio = !empty($_GET['fecha_inicio']) ? $_GET['fecha_inicio'] : null;
    $fecha_fin = !empty($_GET['fecha_fin']) ? $_GET['fecha_fin'] : null;

    // Obtener información del producto
    $query_producto = "SELECT * FROM producto WHERE codproducto = ?";
    $stmt = $conn->prepare($query_producto);
    $stmt->bind_param("i", $id_producto_actual);
    $stmt->execute();
    $producto_info = $stmt->get_result()->fetch_assoc();

    if ($producto_info) {
        // Obtener compras
        $query_compras = "SELECT c.fecha, c.num_doc, c.proveedor, 
                                 dc.cantidad, dc.precio, (dc.precio * dc.cantidad) as subtotal
                          FROM detalle_compras dc
                          INNER JOIN compras c ON dc.id_compra = c.id
                          WHERE dc.id_producto = ?";

        if ($fecha_inicio && $fecha_fin) {
            $query_compras .= " AND DATE(c.fecha) BETWEEN ? AND ?";
        }
        $query_compras .= " ORDER BY c.fecha ASC";

        $stmt = $conn->prepare($query_compras);
        if ($fecha_inicio && $fecha_fin) {
            $stmt->bind_param("iss", $id_producto_actual, $fecha_inicio, $fecha_fin);
        } else {
            $stmt->bind_param("i", $id_producto_actual);
        }
        $stmt->execute();
        $compras = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

        // Obtener ventas
        $query_ventas = "SELECT v.fecha, v.num_docpe, v.cliente, 
                                dv.cantidad, dv.precio, (dv.precio * dv.cantidad) as subtotal
                         FROM detalle_ventas dv
                         INNER JOIN ventas v ON dv.id_venta = v.id
                         WHERE dv.id_producto = ?";

        if ($fecha_inicio && $fecha_fin) {
            $query_ventas .= " AND DATE(v.fecha) BETWEEN ? AND ?";
        }
        $query_ventas .= " ORDER BY v.fecha ASC";

        $stmt = $conn->prepare($query_ventas);
        if ($fecha_inicio && $fecha_fin) {
            $stmt->bind_param("iss", $id_producto_actual, $fecha_inicio, $fecha_fin);
        } else {
            $stmt->bind_param("i", $id_producto_actual);
        }
        $stmt->execute();
        $ventas = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

        // Calcular totales
        $total_compras = array_sum(array_column($compras, 'cantidad'));
        $total_ventas = array_sum(array_column($ventas, 'cantidad'));
        $stock_actual = $producto_info['existencia'];

        $resultado_kardex = [
            'producto' => $producto_info,
            'compras' => $compras,
            'ventas' => $ventas,
            'total_compras' => $total_compras,
            'total_ventas' => $total_ventas,
            'stock_actual' => $stock_actual
        ];
    }
}
?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kardex de Productos - Control de Inventario</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            padding-top: 20px;
        }

        .card {
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }

        .card-header {
            border-radius: 10px 10px 0 0 !important;
            font-weight: bold;
        }

        .btn-buscar {
            border-radius: 0 5px 5px 0;
        }

        .table th {
            background-color: #f1f1f1;
            border-top: none;
        }

        .movimiento-compra {
            background-color: rgba(40, 167, 69, 0.1);
        }

        .movimiento-venta {
            background-color: rgba(255, 193, 7, 0.1);
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <!-- Encabezado -->
                <div class="text-center mb-4">
                    <h1 class="text-primary">📊 Kardex de Productos </h1>
                    <p class="text-muted">Control de inventario de productos - Ingresos y salidas</p>
                </div>

                <!-- Tarjeta principal -->
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h4 class="mb-0">🔍 Buscar Producto para Kardex</h4>
                    </div>
                    <div class="card-body">
                        <!-- Formulario de búsqueda -->
                        <form method="GET" action="" class="mb-4">
                            <div class="row g-3">
                                <div class="col-md-10">
                                    <label for="buscar" class="form-label">Buscar por código o nombre:</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control form-control-lg" id="buscar"
                                            name="buscar" placeholder="Ejemplo: AMOXI500 o Amoxicilina"
                                            value="<?php echo htmlspecialchars($termino_busqueda); ?>" required>
                                        <button class="btn btn-primary btn-lg btn-buscar" type="submit">
                                            🔍 Buscar
                                        </button>
                                    </div>
                                </div>
                                <div class="col-md-2 d-flex align-items-end">
                                    <a href="/Botica/views/ventas/kardex.php" class="btn btn-secondary w-100">🔄
                                        Mostrar</a>
                                </div>
                            </div>
                        </form>

                        <!-- Resultados de búsqueda -->
                        <?php if (!empty($productos)): ?>
                            <div class="card mb-4">
                                <div class="card-header bg-success text-white">
                                    <h5 class="mb-0">📋 Productos Encontrados (<?php echo count($productos); ?>)</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Código</th>
                                                    <th>Nombre</th>
                                                    <th>Precio</th>
                                                    <th>Stock</th>
                                                    <th>Acción</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($productos as $producto): ?>
                                                    <tr>
                                                        <td><strong><?php echo htmlspecialchars($producto['codigo']); ?></strong>
                                                        </td>
                                                        <td><?php echo htmlspecialchars($producto['descripcion']); ?></td>
                                                        <td>S/. <?php echo number_format($producto['precio'], 2); ?></td>
                                                        <td>
                                                            <span
                                                                class="badge <?php echo $producto['existencia'] > 0 ? 'bg-success' : 'bg-danger'; ?>">
                                                                <?php echo $producto['existencia']; ?>
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <form method="GET" action="" style="display: inline;">
                                                                <input type="hidden" name="id_producto"
                                                                    value="<?php echo $producto['codproducto']; ?>">
                                                                <input type="hidden" name="buscar"
                                                                    value="<?php echo htmlspecialchars($termino_busqueda); ?>">
                                                                <button type="submit" class="btn btn-sm btn-primary">
                                                                    📊 Ver Kardex
                                                                </button>
                                                            </form>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        <?php elseif (isset($_GET['buscar'])): ?>
                            <div class="alert alert-warning">
                                ⚠️ No se encontraron productos con el término:
                                <strong>"<?php echo htmlspecialchars($termino_busqueda); ?>"</strong>
                            </div>
                        <?php endif; ?>

                        <!-- Filtros para kardex -->
                        <?php if ($id_producto_actual > 0): ?>
                            <div class="card mb-4">
                                <div class="card-header bg-warning text-dark">
                                    <h5 class="mb-0">📅 Filtros del Reporte</h5>
                                </div>
                                <div class="card-body">
                                    <form method="GET" action="" class="row g-3">
                                        <input type="hidden" name="id_producto" value="<?php echo $id_producto_actual; ?>">
                                        <input type="hidden" name="buscar"
                                            value="<?php echo htmlspecialchars($termino_busqueda); ?>">

                                        <div class="col-md-4">
                                            <label for="fecha_inicio">Fecha Inicio:</label>
                                            <input type="date" class="form-control" id="fecha_inicio" name="fecha_inicio"
                                                value="<?php echo isset($_GET['fecha_inicio']) ? $_GET['fecha_inicio'] : ''; ?>">
                                        </div>
                                        <div class="col-md-4">
                                            <label for="fecha_fin">Fecha Fin:</label>
                                            <input type="date" class="form-control" id="fecha_fin" name="fecha_fin"
                                                value="<?php echo isset($_GET['fecha_fin']) ? $_GET['fecha_fin'] : ''; ?>">
                                        </div>
                                        <div class="col-md-4 d-flex align-items-end">
                                            <div class="d-grid gap-2 w-100">
                                                <button type="submit" class="btn btn-success">🔄 Aplicar Filtros</button>
                                                <a href="?id_producto=<?php echo $id_producto_actual; ?>&buscar=<?php echo urlencode($termino_busqueda); ?>"
                                                    class="btn btn-outline-secondary">🗑️ Limpiar Filtros</a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        <?php endif; ?>

                        <!-- Reporte Kardex -->
                        <?php if ($resultado_kardex): ?>
                            <div class="card">
                                <div class="card-header bg-info text-white">
                                    <h4 class="mb-0">
                                        📈 Reporte Kardex -
                                        <?php echo htmlspecialchars($resultado_kardex['producto']['descripcion']); ?>
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <!-- Información del producto -->
                                    <div class="row mb-4">
                                        <div class="col-md-6">
                                            <h5>📋 Información del Producto</h5>
                                            <p><strong>Código:</strong>
                                                <?php echo htmlspecialchars($resultado_kardex['producto']['codigo']); ?></p>
                                            <p><strong>Descripción:</strong>
                                                <?php echo htmlspecialchars($resultado_kardex['producto']['descripcion']); ?>
                                            </p>
                                            <p><strong>Precio Actual:</strong>
                                                S/. <?php echo number_format($resultado_kardex['producto']['precio'], 2); ?>
                                            </p>
                                        </div>
                                        <div class="col-md-6">
                                            <h5>📊 Resumen</h5>
                                            <div class="row">
                                                <div class="col-6">
                                                    <div class="alert alert-success">
                                                        <h6>Compras Totales</h6>
                                                        <h3><?php echo $resultado_kardex['total_compras']; ?></h3>
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="alert alert-warning">
                                                        <h6>Ventas Totales</h6>
                                                        <h3><?php echo $resultado_kardex['total_ventas']; ?></h3>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="alert alert-primary">
                                                <h6>Stock Actual</h6>
                                                <h2><?php echo $resultado_kardex['stock_actual']; ?> unidades</h2>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Movimientos de Compras -->
                                    <?php if (!empty($resultado_kardex['compras'])): ?>
                                        <h5>🛒 Compras (Ingresos)</h5>
                                        <div class="table-responsive mb-4">
                                            <table class="table table-bordered">
                                                <thead class="table-success">
                                                    <tr>
                                                        <th>Fecha</th>
                                                        <th>Factura</th>
                                                        <th>Proveedor</th>
                                                        <th>Cantidad</th>
                                                        <th>Precio Unit.</th>
                                                        <th>Subtotal</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php foreach ($resultado_kardex['compras'] as $compra): ?>
                                                        <tr class="movimiento-compra">
                                                            <td><?php echo date('d/m/Y', strtotime($compra['fecha'])); ?></td>
                                                            <td><?php echo htmlspecialchars($compra['num_doc']); ?></td>
                                                            <td><?php echo htmlspecialchars($compra['proveedor']); ?></td>
                                                            <td class="text-success"><?php echo $compra['cantidad']; ?></td>
                                                            <td>S/. <?php echo number_format($compra['precio'], 2); ?></td>
                                                            <td>S/. <?php echo number_format($compra['subtotal'], 2); ?></td>
                                                        </tr>
                                                    <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    <?php endif; ?>

                                    <!-- Movimientos de Ventas -->
                                    <?php if (!empty($resultado_kardex['ventas'])): ?>
                                        <h5>💰 Ventas (Salidas)</h5>
                                        <div class="table-responsive">
                                            <table class="table table-bordered">
                                                <thead class="table-warning">
                                                    <tr>
                                                        <th>Fecha</th>
                                                        <th>N°Documento</th>
                                                        <th>Cliente</th>
                                                        <th>Cantidad</th>
                                                        <th>Precio Unit.</th>
                                                        <th>Subtotal</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php foreach ($resultado_kardex['ventas'] as $venta): ?>
                                                        <tr class="movimiento-venta">
                                                            <td><?php echo date('d/m/Y', strtotime($venta['fecha'])); ?></td>
                                                            <td><?php echo htmlspecialchars($venta['num_docpe']); ?></td>
                                                            <td><?php echo htmlspecialchars($venta['cliente']); ?></td>
                                                            <td class="text-danger"><?php echo $venta['cantidad']; ?></td>
                                                            <td>S/. <?php echo number_format($venta['precio'], 2); ?></td>
                                                            <td>S/. <?php echo number_format($venta['subtotal'], 2); ?></td>
                                                        </tr>
                                                    <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    <?php endif; ?>

                                    <!-- Si no hay movimientos -->
                                    <?php if (empty($resultado_kardex['compras']) && empty($resultado_kardex['ventas'])): ?>
                                        <div class="alert alert-info">
                                            ℹ️ No se encontraron movimientos para este producto en el período seleccionado.
                                        </div>
                                    <?php endif; ?>

                                    <!-- Botones de acción -->
                                    <div class="text-center mt-4">
                                        <a href="/Botica/views/ventas/kardex.php" class="btn btn-primary">🔍 Nueva
                                            Búsqueda</a>
                                        <button onclick="window.print()" class="btn btn-success">🖨️ Imprimir
                                            Reporte</button>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        $(document).ready(function () {
            // Auto-focus en el campo de búsqueda
            $('#buscar').focus();

            // Auto-completar fecha fin con fecha inicio
            $('#fecha_inicio').change(function () {
                if ($('#fecha_fin').val() === '') {
                    $('#fecha_fin').val($(this).val());
                }
            });

            // Validar fechas
            $('form').submit(function () {
                var fechaInicio = $('#fecha_inicio').val();
                var fechaFin = $('#fecha_fin').val();

                if (fechaInicio && fechaFin && fechaInicio > fechaFin) {
                    alert('❌ Error: La fecha de inicio no puede ser mayor a la fecha fin');
                    return false;
                }
                return true;
            });
        });
    </script>
</body>

</html>

<?php
// Cerrar conexión
$conn->close();
?>