<?php
// ============================================
// CONFIGURACIÓN DE LA BASE DE DATOS
// ============================================
$servidor = "localhost";
$usuario_db = "yoveraes_userdb";       // Cambia esto
$password_db = "t7@s5FxYn1GB";          // Cambia esto
$base_datos = "yoveraes_botica"; // Cambia esto

// Crear conexión
try {
    $conexion = new PDO(
        "mysql:host=$servidor;dbname=$base_datos;charset=utf8mb4", 
        $usuario_db, 
        $password_db
    );
    $conexion->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    die("❌ ERROR DE CONEXIÓN: " . $e->getMessage());
}

// ============================================
// PROCESAR FORMULARIO CUANDO SE ENVÍA
// ============================================
$mensaje = "";
$mensaje_tipo = ""; // success, error, warning

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['guardar_movimiento'])) {
    // Obtener datos del formulario
    $tipo = trim($_POST['tipo']);
    $monto = floatval($_POST['monto']);
    $descripcion = trim($_POST['descripcion']);
    $usuario_id = intval($_POST['usuario_id']);
    $clave = trim($_POST['clave']);
    
    // Validaciones
    $errores = [];
    
    if (!in_array($tipo, ['ingreso', 'egreso'])) {
        $errores[] = "Tipo de movimiento inválido";
    }
    
    if ($monto <= 0) {
        $errores[] = "El monto debe ser mayor a 0";
    }
    
    if (empty($descripcion)) {
        $errores[] = "La descripción es obligatoria";
    }
    
    if ($usuario_id <= 0) {
        $errores[] = "Debe seleccionar un usuario";
    }
    
    if (empty($clave)) {
        $errores[] = "La contraseña es obligatoria";
    }
    
    // Si no hay errores, procesar
    if (empty($errores)) {
        try {
            // 1. Verificar que el usuario y contraseña coincidan (TEXTO PLANO)
            $sql_verificar = "SELECT idusuario, correo FROM usuario WHERE idusuario = :id AND clavecaja = :clave AND status = 1";
            $stmt_verificar = $conexion->prepare($sql_verificar);
            $stmt_verificar->execute([
                ':id' => $usuario_id,
                ':clave' => $clave  // Comparación en texto plano
            ]);
            
            $usuario_valido = $stmt_verificar->fetch(PDO::FETCH_ASSOC);
            
            if ($usuario_valido) {
                // 2. Insertar el movimiento en la caja
                $sql_insertar = "INSERT INTO caja (tipo, monto, descripcion, usuario_id, fecha) 
                                VALUES (:tipo, :monto, :descripcion, :usuario_id, NOW())";
                
                $stmt_insertar = $conexion->prepare($sql_insertar);
                $stmt_insertar->execute([
                    ':tipo' => $tipo,
                    ':monto' => $monto,
                    ':descripcion' => $descripcion,
                    ':usuario_id' => $usuario_id
                ]);
                
                $mensaje = "✅ Movimiento registrado exitosamente";
                $mensaje_tipo = "success";
                
                // Limpiar campos del formulario (excepto usuario seleccionado)
                $_POST['monto'] = '';
                $_POST['descripcion'] = '';
                $_POST['clave'] = '';
                
            } else {
                $mensaje = "❌ Contraseña incorrecta o usuario inactivo";
                $mensaje_tipo = "error";
            }
            
        } catch(PDOException $e) {
            $mensaje = "❌ Error al guardar: " . $e->getMessage();
            $mensaje_tipo = "error";
        }
    } else {
        $mensaje = "❌ " . implode("<br>", $errores);
        $mensaje_tipo = "error";
    }
}

// ============================================
// OBTENER DATOS PARA MOSTRAR
// ============================================

// 1. Obtener lista de usuarios activos
$sql_usuarios = "SELECT idusuario, nombre, correo FROM usuario WHERE status = 1 ORDER BY correo";
$usuarios = $conexion->query($sql_usuarios)->fetchAll(PDO::FETCH_ASSOC);

// 2. Obtener movimientos del día actual
$sql_movimientos = "
    SELECT 
        c.id_caja,
        c.tipo,
        c.monto,
        c.descripcion,
        c.fecha,
        u.correo as usuario_login
    FROM caja c
    INNER JOIN usuario u ON c.usuario_id = u.idusuario
    WHERE DATE(c.fecha) = CURDATE()
    ORDER BY c.fecha DESC
";

$movimientos = $conexion->query($sql_movimientos)->fetchAll(PDO::FETCH_ASSOC);

// 3. Calcular totales del día
$total_ingresos = 0;
$total_egresos = 0;

foreach ($movimientos as $mov) {
    if ($mov['tipo'] == 'ingreso') {
        $total_ingresos += $mov['monto'];
    } elseif ($mov['tipo'] == 'egreso') {
        $total_egresos += $mov['monto'];
    }
}

$saldo_dia = $total_ingresos - $total_egresos;

// 4. Obtener estadísticas adicionales
$sql_estadisticas = "
    SELECT 
        COUNT(*) as total_movimientos,
        SUM(CASE WHEN tipo = 'ingreso' THEN monto ELSE 0 END) as total_ingresos,
        SUM(CASE WHEN tipo = 'egreso' THEN monto ELSE 0 END) as total_egresos
    FROM caja
    WHERE DATE(fecha) = CURDATE()
";

$estadisticas = $conexion->query($sql_estadisticas)->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Control de Caja - Movimientos Diarios</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --color-ingreso: #28a745;
            --color-egreso: #dc3545;
            --color-primary: #007bff;
            --color-secondary: #6c757d;
            --color-light: #f8f9fa;
            --color-dark: #343a40;
        }
        
        body {
            background-color: #f5f7fb;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .navbar-custom {
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .card-custom {
            border-radius: 10px;
            border: none;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
            transition: transform 0.3s;
            margin-bottom: 20px;
        }
        
        .card-custom:hover {
            transform: translateY(-5px);
        }
        
        .card-header-custom {
            background: linear-gradient(135deg, #4a6fa5 0%, #2c3e50 100%);
            color: white;
            border-radius: 10px 10px 0 0 !important;
            padding: 15px 20px;
            font-weight: 600;
        }
        
        .total-card {
            text-align: center;
            padding: 20px;
            border-radius: 8px;
            color: white;
            margin-bottom: 15px;
        }
        
        .total-ingresos {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        }
        
        .total-egresos {
            background: linear-gradient(135deg, #dc3545 0%, #fd7e14 100%);
        }
        
        .total-saldo {
            background: linear-gradient(135deg, #007bff 0%, #6610f2 100%);
        }
        
        .badge-ingreso {
            background-color: var(--color-ingreso);
            color: white;
            padding: 5px 10px;
            border-radius: 20px;
            font-weight: 500;
        }
        
        .badge-egreso {
            background-color: var(--color-egreso);
            color: white;
            padding: 5px 10px;
            border-radius: 20px;
            font-weight: 500;
        }
        
        .table-custom th {
            background-color: #f1f5fd;
            border-top: none;
            font-weight: 600;
            color: #495057;
        }
        
        .movimiento-row:hover {
            background-color: #f8f9fa;
        }
        
        .btn-guardar {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            border: none;
            padding: 12px 30px;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn-guardar:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(40, 167, 69, 0.3);
        }
        
        .form-control:focus {
            border-color: #4a6fa5;
            box-shadow: 0 0 0 0.2rem rgba(74, 111, 165, 0.25);
        }
        
        .alert-custom {
            border-radius: 8px;
            border: none;
        }
        
        .fecha-hoy {
            font-size: 0.9rem;
            color: #6c757d;
        }
        
        .movimiento-count {
            font-size: 1.2rem;
            font-weight: bold;
            color: #2c3e50;
        }
        
        @media (max-width: 768px) {
            .total-card {
                margin-bottom: 10px;
            }
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark navbar-custom">
        <div class="container-fluid">
            <a class="navbar-brand" href="#">
                <i class="fas fa-cash-register me-2"></i>
                <strong>Control de Caja</strong>
            </a>
            <div class="d-flex align-items-center text-white">
                <i class="fas fa-calendar-day me-2"></i>
                <span class="fecha-hoy"><?php echo date('d/m/Y'); ?></span>
            </div>
        </div>
    </nav>

    <div class="container-fluid mt-4">
        <div class="row">
            
            <!-- COLUMNA IZQUIERDA: FORMULARIO -->
            <div class="col-lg-4">
                <div class="card card-custom">
                    <div class="card-header card-header-custom">
                        <i class="fas fa-plus-circle me-2"></i> NUEVO MOVIMIENTO
                    </div>
                    <div class="card-body">
                        <!-- Mensaje de confirmación/error -->
                        <?php if (!empty($mensaje)): ?>
                            <div class="alert alert-<?php echo $mensaje_tipo == 'success' ? 'success' : 'danger'; ?> alert-custom alert-dismissible fade show" role="alert">
                                <?php echo $mensaje; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php endif; ?>
                        
                        <form method="POST" action="" id="formMovimiento">
                            <!-- Tipo de Movimiento -->
                            <div class="mb-3">
                                <label for="tipo" class="form-label">
                                    <i class="fas fa-exchange-alt me-1"></i> Tipo de Movimiento *
                                </label>
                                <select class="form-select" id="tipo" name="tipo" required>
                                    <option value="" selected disabled>Seleccionar tipo...</option>
                                    <option value="ingreso" <?php echo (isset($_POST['tipo']) && $_POST['tipo'] == 'ingreso') ? 'selected' : ''; ?>>💰 Ingreso</option>
                                    <option value="egreso" <?php echo (isset($_POST['tipo']) && $_POST['tipo'] == 'egreso') ? 'selected' : ''; ?>>💳 Egreso</option>
                                </select>
                            </div>
                            
                            <!-- Monto -->
                            <div class="mb-3">
                                <label for="monto" class="form-label">
                                    <i class="fas fa-money-bill-wave me-1"></i> Monto (S/.) *
                                </label>
                                <div class="input-group">
                                    <span class="input-group-text">S/. </span>
                                    <input type="number" 
                                           class="form-control" 
                                           id="monto" 
                                           name="monto" 
                                           step="0.01" 
                                           min="0.01" 
                                           value="<?php echo $_POST['monto'] ?? ''; ?>" 
                                           placeholder="0.00" 
                                           required>
                                </div>
                                <small class="form-text text-muted">Ingrese el monto con dos decimales</small>
                            </div>
                            
                            <!-- Descripción -->
                            <div class="mb-3">
                                <label for="descripcion" class="form-label">
                                    <i class="fas fa-file-alt me-1"></i> Descripción *
                                </label>
                                <textarea class="form-control" 
                                          id="descripcion" 
                                          name="descripcion" 
                                          rows="2" 
                                          placeholder="Ej: Venta al contado, Pago de servicios, Retiro para compra..." 
                                          required><?php echo $_POST['descripcion'] ?? ''; ?></textarea>
                            </div>
                            
                            <!-- Usuario -->
                            <div class="mb-3">
                                <label for="usuario_id" class="form-label">
                                    <i class="fas fa-user me-1"></i> Usuario Responsable *
                                </label>
                                <select class="form-select" id="usuario_id" name="usuario_id" required>
                                    <option value="" selected disabled>Seleccionar usuario...</option>
                                    <?php foreach ($usuarios as $usuario): ?>
                                        <option value="<?php echo $usuario['idusuario']; ?>" 
                                            <?php echo (isset($_POST['usuario_id']) && $_POST['usuario_id'] == $usuario['idusuario']) ? 'selected' : ''; ?>>
                                            👤 <?php echo htmlspecialchars($usuario['nombre'] . ' (' . $usuario['correo'] . ')'); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            
                            <!-- Contraseña -->
                            <div class="mb-4">
                                <label for="clave" class="form-label">
                                    <i class="fas fa-lock me-1"></i> Contraseña del Usuario *
                                </label>
                                <input type="password" 
                                       class="form-control" 
                                       id="clave" 
                                       name="clave" 
                                       placeholder="Ingrese la contraseña" 
                                       required>
                                <small class="form-text text-muted">Para validar la identidad del usuario</small>
                            </div>
                            
                            <!-- Botón Guardar -->
                            <button type="submit" 
                                    name="guardar_movimiento" 
                                    class="btn btn-guardar btn-lg w-100">
                                <i class="fas fa-save me-2"></i> GUARDAR MOVIMIENTO
                            </button>
                        </form>
                        
                        <!-- Nota de seguridad -->
                        <div class="alert alert-warning alert-custom mt-4">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            <strong>Nota:</strong> La contraseña valida es la asignada para Movimientos de Caja.
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- COLUMNA DERECHA: MOVIMIENTOS DEL DÍA -->
            <div class="col-lg-8">
                <!-- Tarjetas de Total -->
                <div class="row mb-4">
                    <div class="col-md-4">
                        <div class="total-card total-ingresos">
                            <i class="fas fa-arrow-down fa-2x mb-2"></i>
                            <h5>TOTAL INGRESOS</h5>
                            <h2 class="movimiento-count">S/. <?php echo number_format($total_ingresos, 2); ?></h2>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="total-card total-egresos">
                            <i class="fas fa-arrow-up fa-2x mb-2"></i>
                            <h5>TOTAL EGRESOS</h5>
                            <h2 class="movimiento-count">S/. <?php echo number_format($total_egresos, 2); ?></h2>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="total-card total-saldo">
                            <i class="fas fa-balance-scale fa-2x mb-2"></i>
                            <h5>SALDO DEL DÍA</h5>
                            <h2 class="movimiento-count">S/. <?php echo number_format($saldo_dia, 2); ?></h2>
                        </div>
                    </div>
                </div>
                
                <!-- Card de Movimientos -->
                <div class="card card-custom">
                    <div class="card-header card-header-custom d-flex justify-content-between align-items-center">
                        <div>
                            <i class="fas fa-list-alt me-2"></i> MOVIMIENTOS DEL DÍA
                        </div>
                        <div class="badge bg-light text-dark p-2">
                            <i class="fas fa-history me-1"></i>
                            <?php echo count($movimientos); ?> registros
                        </div>
                    </div>
                    <div class="card-body">
                        <?php if (empty($movimientos)): ?>
                            <div class="text-center py-5">
                                <i class="fas fa-file-invoice-dollar fa-4x text-muted mb-3"></i>
                                <h4 class="text-muted">No hay movimientos registrados hoy</h4>
                                <p class="text-muted">Comience registrando un nuevo movimiento</p>
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-hover table-custom">
                                    <thead>
                                        <tr>
                                            <th width="100">HORA</th>
                                            <th width="120">TIPO</th>
                                            <th width="150">MONTO</th>
                                            <th>DESCRIPCIÓN</th>
                                            <th width="200">USUARIO</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($movimientos as $movimiento): ?>
                                            <tr class="movimiento-row">
                                                <td>
                                                    <span class="text-muted">
                                                        <?php echo date('H:i', strtotime($movimiento['fecha'])); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <?php if ($movimiento['tipo'] == 'ingreso'): ?>
                                                        <span class="badge-ingreso">
                                                            <i class="fas fa-arrow-down me-1"></i> INGRESO
                                                        </span>
                                                    <?php else: ?>
                                                        <span class="badge-egreso">
                                                            <i class="fas fa-arrow-up me-1"></i> EGRESO
                                                        </span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <strong class="<?php echo $movimiento['tipo'] == 'ingreso' ? 'text-success' : 'text-danger'; ?>">
                                                        $<?php echo number_format($movimiento['monto'], 2); ?>
                                                    </strong>
                                                </td>
                                                <td>
                                                    <?php echo htmlspecialchars($movimiento['descripcion']); ?>
                                                </td>
                                                <td>
                                                    <div>
                                                        <!--small class="text-muted">
                                                            <i class="fas fa-user-circle me-1"></i>
                                                            <?php echo htmlspecialchars($movimiento['nombre']); ?>
                                                        </!--small--!>
                                                        <!--br--!>
                                                        <small class="text-muted">
                                                            @<?php echo htmlspecialchars($movimiento['usuario_login']); ?>
                                                        </small>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Resumen final -->
                            <div class="row mt-4">
                                <div class="col-md-6">
                                    <div class="alert alert-info alert-custom">
                                        <i class="fas fa-info-circle me-2"></i>
                                        <strong>Resumen:</strong> 
                                        <?php echo $estadisticas['total_movimientos'] ?? 0; ?> movimientos registrados hoy
                                    </div>
                                </div>
                                <div class="col-md-6 text-end">
                                    <button class="btn btn-outline-primary" onclick="window.print()">
                                        <i class="fas fa-print me-2"></i> Imprimir Reporte
                                    </button>
                                    <button class="btn btn-outline-success ms-2" id="btnExportar">
                                        <i class="fas fa-file-excel me-2"></i> Exportar
                                    </button>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Footer -->
        <!--div class="row mt-4">
            <div class="col-12 text-center text-muted">
                <hr>
                <p>
                    <i class="fas fa-copyright"></i> Movimiento de Control de Caja | 
                    Desarrollado por Polo | 
                    <?php echo date('Y'); ?>
                </p>
            </div>
        </!--div--!>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // JavaScript para mejorar la experiencia
        document.addEventListener('DOMContentLoaded', function() {
            // Formatear monto al salir del campo
            document.getElementById('monto').addEventListener('blur', function(e) {
                if (this.value) {
                    this.value = parseFloat(this.value).toFixed(2);
                }
            });
            
            // Confirmación para egresos grandes
            document.getElementById('formMovimiento').addEventListener('submit', function(e) {
                const tipo = document.getElementById('tipo').value;
                const monto = parseFloat(document.getElementById('monto').value);
                
                if (tipo === 'egreso' && monto > 5000) {
                    if (!confirm('⚠️ ATENCIÓN: Está registrando un EGRESO mayor a $5,000. ¿Está seguro?')) {
                        e.preventDefault();
                    }
                }
            });
            
            // Botón exportar (simulado)
            document.getElementById('btnExportar').addEventListener('click', function() {
                alert('Función de exportación a Excel habilitada. Los datos se exportarán.');
                // Aquí iría el código para exportar a Excel
            });
            
            // Auto-seleccionar primer usuario si solo hay uno
            const selectUsuario = document.getElementById('usuario_id');
            if (selectUsuario.options.length === 2) { // 1 option + el placeholder
                selectUsuario.selectedIndex = 1;
            }
        });
    </script>
</body>
</html>