<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
if (!isset($_POST["metodo"])) {
    $_POST["metodo"] = "";
}
if (!isset($_POST["total"])) {
    $_POST["total"] = "";
}
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Venta Diaria</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="/Botica/views/ventas/js/jquery.min.js"></script>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css"
        integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
    <script language="javascript" src="/Botica/views/ventas/js/jquery-3.1.1.min.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        function obtenerNumeroCorrelativo() {
            var tipo = document.getElementById("tipo_cpe").value;
            var xhr = new XMLHttpRequest();
            xhr.open("POST", "/Botica/views/ventas/mostrar_comprobantes.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.onload = function () {
                if (xhr.status === 200) {
                    // Actualizar el valor del campo de texto con el resultado recibido
                    document.getElementById("numero_correlativo").value = xhr.responseText;
                } else {
                    document.getElementById("numero_correlativo").value = "Error al obtener el número.";
                }
            };
            xhr.send("tipo_cpe=" + encodeURIComponent(tipo));
        }
    </script>
    <script type="text/javascript">
        $(document).ready(function () {
            //$('#ruc_num').val('RUC');
            //$('#tipo_doc').val('DNI');
            $('#tipo_cpe').val('A');
            $('#metodopdgo').val('CONTADO');
        })
    </script>
    <style>
        /* Estilos personalizados para el botón */
        .boton-personalizado {
            background-color: #4CAF50;
            /* Verde */
            border: none;
            color: white;
            padding: 15px 32px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 18px;
            margin: 4px 2px;
            cursor: pointer;
            border-radius: 12px;
        }

        .boton-personalizado:hover {
            background-color: #45a049;
            /* Verde más oscuro */
        }
    </style>
    <style>
        /* Estilo para reducir la fuente */
        .tabla-pequena {
            font-size: 14px;
            /* Ajusta el tamaño de la fuente */
            border-collapse: collapse;
            width: 100%;
        }

        .tabla-pequena th,
        .tabla-pequena td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        .tabla-pequena th {
            background-color: #3e64d3;
            text-align: left;
        }
    </style>
    <style>
        /* Estilos básicos */
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }

        .container {
            max-width: 1000px;
            margin: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            padding: 10px;
            border: 1px solid #ccc;
            text-align: center;
        }

        button {
            padding: 5px 10px;
            color: #fff;
            background: #e74c3c;
            border: none;
            cursor: pointer;
        }

        button:hover {
            background: #c0392b;
        }
    </style>
    <script>
        // Cambiar color al enfocar
        function changeColor(element, color) {
            element.style.backgroundColor = color;
        }

        // Restaurar color al salir
        function resetColor(element) {
            element.style.backgroundColor = '';
        }
    </script>
</head>

<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h4 class="subtitle"><i class="fas fa-cart-plus"></i> &nbsp;Pedido | Pedido Diario</h4>
</div>
<div class="card mb-1">
    <div class="card-body">
        <div class="row">
            <div class="col-md-4">
                <div class="input-group mb-3">
                    <span class="input-group-text"><i class="fas fa-search"></i></span>
                    <input type="text" id="dni" autocomplete="off" name="dni" autofocus="autofocus" style="width:150px;"
                        onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)">
                    <button id="prueba" class="btn btn-primary" name="prueba">Buscar DNI</button>
                </div>
                <div style="display: none"><b> DNI : </b><label for="dniNumero" id="dniNumero"></label></div>
                <div style="display: none"><b> Nombres : </b><label for="nombre" id="nombre"></label></div>
                <div style="display: none"><b> Apellido P. : </b><label for="apellidop" id="apellidop"></label>
                </div>
                <div style="display: none"><b> Apellido M. : </b><label for="apellidom" id="apellidom"></label>
                </div>
                <script>
                    $("#prueba").click(function () {
                        var dni = $("#dni").val();
                        $.ajax({
                            type: "POST",
                            url: "/Botica/views/ventas/consulta-dni-ajax.php",
                            data: 'dni=' + dni,
                            dataType: 'json',
                            success: function (data) {
                                if (data == 1) {
                                    alert('El DNI tiene que tener 8 digitos');
                                }
                                else {
                                    console.log(data);
                                    numeroDocumento = data.numeroDocumento;
                                    nombres = data.nombres;
                                    apellidoPaterno = data.apellidoPaterno;
                                    apellidoMaterno = data.apellidoMaterno;
                                    $("#dniNumero").html(data.numeroDocumento);
                                    $("#nombre").html(data.nombres);
                                    $("#apellidop").html(data.apellidoPaterno);
                                    $("#apellidom").html(data.apellidoMaterno);
                                    $("#dniNumeroInput").val(data.numeroDocumento);
                                    $("#nombre-cliente").val(data.nombre);
                                    $("#dir-cliente").val(data.direccion);
                                    $('#numdoc').val(data.numeroDocumento);
                                }
                            }
                        });
                    })
                </script>
            </div>
            <div class="col-md-4">
                <div class="input-group mb-3">
                    <span class="input-group-text"><i class="fas fa-search"></i></span>
                    <input type="text" autocomplete="off" id="ruc" name="ruc" style="width:150px;"
                        onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)">
                    <button id="pruebaruc" class="btn btn-secondary ">Buscar RUC</button>
                </div>
                <div style="display: none" display: none"><b> RUC : </b><label id="rucNumero"></label></div>
                <div style="display: none" display: none"><b> Razón social: </b><label id="razonsocial"></label></div>
                <div style="display: none" display: none"><b> Estado: </b><label id="estado"></label></div>
                <div style="display: none" display: none"><b> Dirección: </b><label id="direccion"></label></div>
                <div style="display: none" display: none"><b> Departamento: </b><label id="departamento"></label>
                </div>
                <script>
                    $("#pruebaruc").click(function () {
                        var ruc = $("#ruc").val();
                        $.ajax({
                            type: "POST",
                            url: "/Botica/views/ventas/consultar-ruc-ajax.php",
                            data: 'ruc=' + ruc,
                            dataType: 'json',
                            success: function (data) {
                                if (data == 1) {
                                    alert('El RUC tiene que tener 11 digitos');
                                }
                                else {
                                    console.log(data);
                                    $("#rucNumero").html(data.numeroDocumento);
                                    $("#razonsocial").html(data.nombre);
                                    $("#estado").html(data.estado);
                                    $("#direccion").html(data.direccion);
                                    $("#departamento").html(data.departamento);
                                    $("#rucNumeroInput").val(data.numeroDocumento);
                                    $("#nombre-cliente").val(data.nombre);
                                    $("#dir-cliente").val(data.direccion);
                                    $("#dniNumeroInput").val(data.numeroDocumento);
                                    $("#nombre-cliente").val(data.nombre);
                                    $("#dir-cliente").val(data.direccion);
                                }
                            }
                        });
                    })
                </script>
            </div>
        </div>
    </div>
</div>

<body>
    <!-- Búsqueda de productos -->
    <div class="col-md-7">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="input-group mb-2">
                        <span class="input-group-text"><i class="fas fa-search"></i></span>
                        <input type="text" id="search" class="form-control" autocomplete="on"
                            placeholder="Buscar producto..." onfocus="changeColor(this, '#f7f201')"
                            onblur="resetColor(this)">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <table id="product-list" class="table table-striped table-hover tabla-pequena" style="width:60%;">
        <thead class="table-dark table-bordered">
            <tr>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;" scope="col">Código</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;" scope="col">Nombre</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;" scope="col">Presentación</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;" scope="col">Precio</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;" scope="col">Stock</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;" scope="col">Acción</th>
            </tr>
        </thead>
        <tbody>
            <!-- Aquí se cargarán los productos -->
        </tbody>
    </table>
    <!-- Tabla de productos seleccionados -->
    <h4>Productos Seleccionados Para Venta</h4>
    <table id="selected-products" class="table table-striped table-hover tabla-pequena" style="width:60%;">
        <thead class="table-dark table-bordered">
            <tr>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;" scope="col">Código</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;" scope="col">Nombre</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;" scope="col">Presentación</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;" scope="col">Precio</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;" scope="col">Cantidad</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;" scope="col">Total</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;" scope="col">Acción</th>
            </tr>
        </thead>
        <tbody>
            <!-- Aquí se agregarán los productos seleccionados -->
        </tbody>
    </table>
    <div class="col-md-7">
        <p style="font-size:25px;color:rgb(25,54,93);height:25px;"><strong>Total Pedido : S/. </strong><i
                class="far fa-money-bill-alt"></i>&nbsp;&nbsp;&nbsp;&nbsp;<span
                style="width:150px; font-size:25PX; cursor:pointer;text-align: right; background-color: rgb(249,194,35);"
                id="total" name="total">0.00</span></p>

        <input style="display:none;" type="text" id="total-input" name="total-input" required>
    </div>
    <!-- Formulario de datos de venta -->
    <form id="sales-form">
        <div class="row">
            <div class="col-md-7">
                <div class="card">
                    <div class="card-body">
                        <hr>
                        <div class="row">
                            <input type="hidden" id="id-cliente" value="1">
                            <div class="col-md-3">
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-address-card"></i></span>
                                    </div>
                                    <input style="width:80px;" type="text" class="form-control" id="dniNumeroInput"
                                        name="dniNumeroInput" placeholder="DNI/RUC" value="00000000"
                                        onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)">
                                </div>
                            </div>
                            <div class="col-md-9">
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-users"></i></span>
                                    </div>
                                    <input type="text" class="form-control" id="nombre-cliente" name="nombre-cliente"
                                        placeholder="Nombre" value="CLIENTE VARIOS"
                                        onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)">
                                </div>
                            </div>
                            <div class="col-md-12" style="display:none">
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-home"></i></span>
                                    </div>
                                    <input style="width:150px;" type="text" class="form-control" id="dir-cliente"
                                        name="dir-cliente" placeholder="Dirección"
                                        value="CHICLAYO - CHICLAYO - LAMBAYEQUE" onfocus="changeColor(this, '#f7f201')"
                                        onblur="resetColor(this)">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label for=""><strong style="font-size:16px; color:rgb(25,54,93);">&nbsp;Fecha
                                        Documento</strong><span class="text-danger">*</span></label>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-clipboard-list"></i></span>
                                    </div>
                                    <input type="date" style="font-size:16px;" class="form-control font-weight-bold"
                                        id="FechaSunat" name="FechaSunat" value="<?php date_default_timezone_set('America/Lima');echo date("Y-m-d"); ?>" onfocus="changeColor(this, '#f7f201')"
                                        onblur="resetColor(this)">
                                </div>
                            </div>
                            <div class="col-md-5">
                                <form id="formulario" onsubmit="event.preventDefault(); obtenerNumeroCorrelativo();">
                                    <label for="tipo_cpe"><strong
                                            style="font-size:16px; color:rgb(25,54,93);">&nbsp;Tipo de
                                            Documento</strong><span class="text-danger">*</span></label>
                                    <div class="input-group mb-3">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="fa fa-calendar-check"></i></span>
                                        </div>
                                        <select class="form-control" id="tipo_cpe" name="tipo_cpe"
                                            style="cursor:pointer; width:180px;font-size:16px; font-weight-bold;"
                                            onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)"
                                            onchange="obtenerNumeroCorrelativo();">
                                            <option value="A">SELECCIONE</option>
                                            <option value="N">NOTA VENTA</option>
                                            <option value="B">BOLETA</option>
                                            <option value="F">FACTURA</option>
                                        </select>
                                        <button style="display:none;" type="submit">Mostrar Número Correlativo</button>
                                    </div>
                                </form>
                            </div>
                            <div class="col-md-4">
                                <label for="numero_correlativo"><strong
                                        style="font-size:16px; color:rgb(25,54,93);">&nbsp;N° de
                                        Documento</strong><span class="text-danger">*</span></label>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fa fa-credit-card"></i></span>
                                    </div>
                                    <input type="text" class="form-control font-weight-bold" id="numero_correlativo"
                                        name="numero_correlativo" value="" readonly
                                        style="width:80px;font-size:20px;text-align:center;background-color: rgb(25,54,93);color: rgb(255,255,255);">
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="input-group mb-2">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i
                                                class="fas fa-credit-card mr-1"></i>Metodo</span>
                                        <input style="display:none;width:120px;text-align:Right;font-size:16px;"
                                            placeholder="0.00" type="number" class="form-control" id="pvpmixto"
                                            name="pvpmixto">
                                    </div>
                                    <select id="metodopdgo" name="metodopdgo" class="form-control"
                                        style="cursor:pointer; width:180px;font-size:16px; font-weight-bold;"
                                        onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)">
                                        <option value="CONTADO">CONTADO</option>
                                        <option value="TRANSFERENCIA">TRANSFERENCIA</option>
                                        <option value="YAPE">YAPE</option>
                                        <option value="PLIN">PLIN</option>
                                        <option value="OTRO">OTRO</option>
                                    </select>
                                    <script>
                                        const metodoz = document.querySelector('#metodopdgo');
                                        console.log(metodoz)
                                        metodoz.addEventListener('change', () => {
                                            let valorOption = metodoz.value;
                                            console.log(valorOption);
                                            var optionSelect = metodoz.options[metodoz.selectedIndex];
                                            console.log("Opción:", optionSelect.text);
                                            console.log("Valor:", optionSelect.value);
                                            let inputResult = document.querySelector('#metodo').text = (optionSelect.text);
                                            console.log(inputResult)
                                            document.querySelector('#metodo').value = optionSelect.text;
                                        });
                                        const tipocpe = document.querySelector('#tipo_cpe');
                                        console.log(tipocpe)
                                        tipocpe.addEventListener('change', () => {
                                            let valorOption = tipocpe.value;
                                            console.log(valorOption);
                                            var optionSelect = tipocpe.options[tipocpe.selectedIndex];
                                            console.log("Opción:", optionSelect.text);
                                            console.log("Valor:", optionSelect.value);
                                            let inputResult = document.querySelector('#tpCpe').text = (optionSelect.value);
                                            console.log(inputResult)
                                            document.querySelector('#tpCpe').value = optionSelect.value;
                                        });
                                    </script>
                                    <input style="display:none;" type="text" id="metodo" name="metodo"
                                        placeholder="Método de pago" required value="CONTADO">
                                    <input style="display:none;" type="text" id="tpCpe" name="tpCpe"
                                        placeholder="Método de pago" required value="">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <button type="submit" class="boton-personalizado btn-block"><i class="fas fa-save"></i>
                                    Tomar Pedido</button>
                                <button id="imprimir" class="dtn-danger btn-block" style="display:none;"
                                    onclick="window.print();">Imprimir</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <script>
        $(document).ready(function () {
            // Buscar productos
            $("#search").on("keyup", function () {
                const query = $(this).val();
                $.ajax({
                    url: "/Botica/views/ventas/buscar_producto.php",
                    type: "GET",
                    data: { query },
                    success: function (data) {
                        $("#product-list tbody").html(data);
                    }
                });
            });
            // Agregar producto seleccionado
            $(document).on("click", ".add-product", function () {
                const row = $(this).closest("tr");
                const id = row.find(".prod-id").text();
                const nombre = row.find(".prod-nombre").text();
                const presentacion = row.find(".prod-presentacion").text();
                const precio = parseFloat(row.find(".prod-precio").text());
                const stock = parseInt(row.find(".prod-stock").text());

                if (stock > 0) {
                    const newRow = `
                        <tr>
                            <td style='cursor:pointer;color:rgb(0,0,0);text-align:center;'>${id}</td>
                            <td style='cursor:pointer;color:rgb(0,0,0);text-align:left;'>${nombre}</td>
                            <td style='cursor:pointer;color:rgb(0,0,0);text-align:center;'>${presentacion}</td>
                            <!--td style='cursor:pointer;color:rgb(0,0,0);text-align:right;'>${precio.toFixed(2)}</!--td-->
                            <td>
                            <input type="number" onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)" class="precio" style='cursor:pointer;color:rgb(0,0,0);text-align:right;width:100px;' value="${precio.toFixed(2)}" min="0.01" step="0.01">
                            </td>
                            <td ><input type="number" onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)" style='cursor:pointer;color:rgb(0,0,0);text-align:center;width:100px;' class="cantidad" value="1" min="1" max="${stock}"></td>
                            <td style='cursor:pointer;color:rgb(0,0,0);text-align:right;' class="total">${precio.toFixed(2)}</td>
                            <td><button class="remove-product"><i class="fas fa-trash-alt"></i> Eliminar</button></td>
                        </tr>`;
                    $("#selected-products tbody").append(newRow);
                    updateTotal();
                } else {
                    alert("Producto sin stock disponible.");
                }
            });
            // Actualizar total al cambiar cantidad
            /*$(document).on("input", ".cantidad", function () {
                const row = $(this).closest("tr");
                const precio = parseFloat(row.find("td:nth-child(4)").text());
                const cantidad = parseInt($(this).val());
                row.find(".total").text((precio * cantidad).toFixed(2));
                updateTotal();
            });*/

            // Evento para recalcular total cuando cambie la cantidad o precio
            $("#selected-products tbody").on("input", ".cantidad, .precio", function () {
                const row = $(this).closest("tr");
                const cantidad = parseFloat(row.find(".cantidad").val());
                const precio = parseFloat(row.find(".precio").val());
                const total = cantidad * precio;

                if (!isNaN(total)) {
                    row.find(".total").text(total.toFixed(2));
                    updateTotal(); // Recalcula el total general
                }
            });
            // Eliminar producto
            $(document).on("click", ".remove-product", function () {
                $(this).closest("tr").remove();
                updateTotal();
            });

            // Guardar venta
            $("#sales-form").on("submit", function (e) {
                e.preventDefault();
                const docident = $("input[name='dniNumeroInput']").val();
                const cliente = $("input[name='nombre-cliente']").val();
                const direcc = $("input[name='dir-cliente']").val();
                const metodo = $("input[name='metodo']").val();
                const FechaSunat = $("input[name='FechaSunat']").val();
                const tipoCpe = $("input[name='tpCpe']").val();
                const numdocumento = $("input[name='numero_correlativo']").val();
                const total = $("input[name='total-input']").val();
                const productos = [];
                $("#selected-products tbody tr").each(function () {
                    const id = $(this).find("td:nth-child(1)").text();
                    const presentacion = $(this).find("td:nth-child(3)").text();
                    const cantidad = $(this).find(".cantidad").val() || 0;
                    const precio = parseFloat($(this).find(".precio").val()) || 0;
                    productos.push({ id, cantidad, presentacion, precio });
                });
                $.ajax({
                    url: "/Botica/views/ventas/guardar_venta.php",
                    type: "POST",
                    data: { cliente, metodo, numdocumento, tipoCpe, direcc, FechaSunat, docident, total, productos },
                    success: function (response) {
                        try {
                            const res = JSON.parse(response);
                            if (res.success) {
                                window.open(`/Botica/views/ventas/imprimirpdf.php?idventa=${res.idventa}&tipo_pago=${res.tipo_pago}&tipoCpe=${res.tipoCpe}`, "_blank");
                                location.reload();
                            } else {
                                alert("Error: " + res.message);
                            }
                        } catch (e) {
                            console.error("Respuesta inválida:", response);
                            alert("Error inesperado. Ver consola.");
                        }
                    }
                });
            });

            // Actualizar total
            function updateTotal() {
                let total = 0;
                $("#selected-products tbody .total").each(function () {
                    total += parseFloat($(this).text());
                });
                $("#total").text(total.toFixed(2));
                $("#total-input").val(total.toFixed(2)); // Sincroniza con el input-text
            }
        });
    </script>
</body>

</html>