<?php
session_start();
require 'conexion.php';
require 'vendor/autoload.php'; // Librería para generar PDFs como FPDF o Dompdf

use Dompdf\Dompdf;

if (isset($_GET['idventas'])) {
    $idVentas = explode(',', $_GET['idventas']);
    $dompdf = new Dompdf();

    $html = '';
    foreach ($idVentas as $id) {
        $query = "SELECT * FROM ventas WHERE id = ?";
        $stmt = $conexion->prepare($query);
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $venta = $result->fetch_assoc();

        $html .= "
            <h1>Documento: {$venta['tipo_documento']}</h1>
            <p>Correlativo: {$venta['correlativo']}</p>
            <p>Precio: S/ {$venta['precio']}</p>
            <hr>
        ";
    }

    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();

    // Enviar el PDF al navegador
    $dompdf->stream("boletas_facturas.pdf", ["Attachment" => false]);
    exit;
}
?>