<?php
// Si necesitas obtener datos del usuario de tu sistema existente
// Por ejemplo, desde variables de sesión o parámetros URL


//session_start();


// Obtener datos del usuario (ajusta según tu sistema)
$id_usuario = $_SESSION['idusuario'] ?? 1; // Ejemplo: valor por defecto
$nombre_usuario = $_SESSION['correo'] ?? 'Usuario Demo';
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cierre de Caja</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            background-color: #f0f2f5;
        }

        .header {
            background-color: #007bff;
            color: white;
            padding: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .container {
            max-width: 1200px;
            margin: 20px auto;
            padding: 20px;
        }

        .section {
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }

        .grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-top: 15px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
            color: #333;
        }

        input,
        select,
        textarea {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }

        .denominacion-item {
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 4px;
            text-align: center;
            background-color: #f9f9f9;
        }

        .denominacion-item h4 {
            color: #007bff;
            margin-bottom: 10px;
            font-size: 14px;
        }

        .total-box {
            background-color: #e7f3ff;
            padding: 15px;
            border-radius: 4px;
            margin-top: 10px;
            text-align: center;
        }

        .button-group {
            display: flex;
            gap: 10px;
            margin-top: 20px;
            justify-content: center;
        }

        button {
            padding: 10px 25px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-weight: bold;
            font-size: 16px;
            transition: background-color 0.3s;
        }

        .btn-primary {
            background-color: #007bff;
            color: white;
        }

        .btn-primary:hover {
            background-color: #0056b3;
        }

        .btn-success {
            background-color: #28a745;
            color: white;
        }

        .btn-success:hover {
            background-color: #1e7e34;
        }

        .btn-pdf {
            background-color: #dc3545;
            color: white;
        }

        .btn-pdf:hover {
            background-color: #c82333;
        }

        .totals {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
            margin-top: 20px;
        }

        .total-item {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 4px;
            text-align: center;
            border: 2px solid #dee2e6;
        }

        .total-item h4 {
            font-size: 14px;
            color: #6c757d;
            margin-bottom: 10px;
        }

        .total-item h3 {
            font-size: 28px;
            color: #28a745;
            font-weight: bold;
        }

        .info-usuario {
            background-color: #e9ecef;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .timestamp {
            text-align: right;
            font-size: 12px;
            color: #666;
            margin-top: 5px;
        }

        .input-cantidad {
            font-size: 18px;
            font-weight: bold;
            text-align: center;
        }

        .subtotal {
            font-weight: bold;
            color: #28a745;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1>🏦 Cierre de Caja</h1>
        <div>
            <span>Usuario: <strong><?php echo htmlspecialchars($nombre_usuario); ?></strong></span>
        </div>
    </div>

    <div class="container">
        <div class="info-usuario">
            <div>
                <strong>ID Usuario:</strong> <?php echo $id_usuario; ?> |
                <strong>Fecha:</strong> <span id="fecha-actual"><?php echo date('d/m/Y'); ?></span>
            </div>
            <div class="timestamp" id="hora-actual"></div>
        </div>

        <div class="section">
            <h2>📊 Ingreso de Monedas y Billetes</h2>
            <div class="grid" id="denominaciones-container">
                <!-- Las denominaciones se cargarán aquí con JavaScript -->
            </div>

            <div class="total-box">
                <h3>💰 Total Efectivo: <span id="total-efectivo" style="font-size: 24px; color: #28a745;">S/.
                        0.00</span>
                </h3>
            </div>
        </div>

        <div class="section">
            <h2>📝 Información Adicional</h2>
            <div class="grid">
                <div class="form-group">
                    <label for="monto_virtual">💳 Monto Virtual:</label>
                    <input type="number" id="monto_virtual" step="0.01" min="0" value="0.00"
                        onchange="calcularTotales()">
                </div>
                <div class="form-group">
                    <label for="num_turno">🔄 Número de Turno:</label>
                    <input type="number" id="num_turno" min="1" value="1">
                </div>
                <div class="form-group">
                    <label for="observaciones">📋 Observaciones:</label>
                    <textarea id="observaciones" rows="3"
                        placeholder="Ingrese observaciones si es necesario..."></textarea>
                </div>
            </div>
        </div>

        <div class="totals">
            <div class="total-item">
                <h4>💵 Total Efectivo</h4>
                <h3 id="final-efectivo">S/. 0.00</h3>
            </div>
            <div class="total-item">
                <h4>💻 Total Virtual</h4>
                <h3 id="final-virtual">S/. 0.00</h3>
            </div>
            <div class="total-item">
                <h4>💰 Gran Total</h4>
                <h3 id="gran-total">S/. 0.00</h3>
            </div>
        </div>

        <div class="button-group">
            <button class="btn-primary" onclick="calcularTotales()">🧮 Calcular Totales</button>
            <button class="btn-success" onclick="guardarArqueo()">💾 Guardar Arqueo</button>
            <button class="btn-pdf" onclick="generarPDF()">📄 Generar PDF</button>
        </div>
    </div>

    <script>
        // Denominaciones de monedas y billetes
        const denominaciones = [
            { id: 'li_m1', valor: 0.10, descripcion: 'Moneda S/. 0.10', tipo: 'moneda' },
            { id: 'li_m2', valor: 0.20, descripcion: 'Moneda S/. 0.20', tipo: 'moneda' },
            { id: 'li_m3', valor: 0.50, descripcion: 'Moneda S/. 0.50', tipo: 'moneda' },
            { id: 'li_m4', valor: 1.00, descripcion: 'Moneda S/. 1.00', tipo: 'moneda' },
            { id: 'li_m5', valor: 2.00, descripcion: 'Moneda S/. 2.00', tipo: 'moneda' },
            { id: 'li_m6', valor: 5.00, descripcion: 'Moneda S/. 5.00', tipo: 'moneda' },
            { id: 'li_m7', valor: 10.00, descripcion: 'Moneda S/. 10.00', tipo: 'moneda' },
            { id: 'li_m8', valor: 20.00, descripcion: 'Billete S/. 20.00', tipo: 'billete' },
            { id: 'li_m9', valor: 50.00, descripcion: 'Billete S/. 50.00', tipo: 'billete' },
            { id: 'li_m10', valor: 100.00, descripcion: 'Billete S/. 100.00', tipo: 'billete' },
            { id: 'li_m11', valor: 200.00, descripcion: 'Billete S/. 200.00', tipo: 'billete' }
        ];

        // Generar campos de entrada para cada denominación
        function generarCamposDenominaciones() {
            const container = document.getElementById('denominaciones-container');
            container.innerHTML = '';

            denominaciones.forEach(denom => {
                const div = document.createElement('div');
                div.className = 'denominacion-item';
                div.innerHTML = `
                    <h4>${denom.descripcion}</h4>
                    <label>Cantidad:</label>
                    <input type="number" 
                           id="${denom.id}" 
                           min="0" 
                           value="0" 
                           class="cantidad-denominacion input-cantidad"
                           data-valor="${denom.valor}"
                           onchange="calcularSubtotal('${denom.id}')"
                           oninput="calcularSubtotal('${denom.id}')">
                    <div style="margin-top: 8px;">
                        <small class="subtotal">Subtotal: $<span id="subtotal_${denom.id}">0.00</span></small>
                    </div>
                `;
                container.appendChild(div);
            });
        }

        // Calcular subtotal por denominación
        function calcularSubtotal(id) {
            const input = document.getElementById(id);
            const cantidad = parseInt(input.value) || 0;
            const valor = parseFloat(input.dataset.valor);
            const subtotal = cantidad * valor;

            document.getElementById(`subtotal_${id}`).textContent = subtotal.toFixed(2);
            calcularTotalEfectivo();
            calcularTotales(); // Actualizar totales automáticamente
        }

        // Calcular total en efectivo
        function calcularTotalEfectivo() {
            let total = 0;
            document.querySelectorAll('.cantidad-denominacion').forEach(input => {
                const cantidad = parseInt(input.value) || 0;
                const valor = parseFloat(input.dataset.valor);
                total += cantidad * valor;
            });

            document.getElementById('total-efectivo').textContent = total.toFixed(2);
            return total;
        }

        // Calcular todos los totales
        function calcularTotales() {
            const efectivo = calcularTotalEfectivo();
            const virtual = parseFloat(document.getElementById('monto_virtual').value) || 0;
            const total = efectivo + virtual;

            document.getElementById('final-efectivo').textContent = `$${efectivo.toFixed(2)}`;
            document.getElementById('final-virtual').textContent = `$${virtual.toFixed(2)}`;
            document.getElementById('gran-total').textContent = `$${total.toFixed(2)}`;

            return { efectivo, virtual, total };
        }

        // Guardar arqueo en la base de datos
        function guardarArqueo() {
            const datos = obtenerDatosArqueo();

            // Validar que al menos haya algún monto
            if (datos.totales.efectivo === 0 && datos.totales.virtual === 0) {
                if (!confirm('⚠️ Ambos montos están en cero. ¿Desea continuar?')) {
                    return;
                }
            }

            fetch('/Botica/views/ventas/guardar_arqueo.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(datos)
            })
                .then(response => response.json())
                .then(result => {
                    if (result.success) {
                        alert('✅ Arqueo guardado exitosamente\nID: ' + result.id_cierre);
                        // Opcional: limpiar formulario
                        // limpiarFormulario();
                    } else {
                        alert('❌ Error: ' + result.message);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('❌ Error de conexión al guardar el arqueo');
                });
        }

        // Generar PDF
        function generarPDF() {
            const datos = obtenerDatosArqueo();

            // Crear formulario temporal para enviar datos
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '/Botica/views/ventas/generar_pdf.php';
            form.target = '_blank';

            // Agregar datos al formulario
            Object.keys(datos).forEach(key => {
                if (typeof datos[key] === 'object') {
                    Object.keys(datos[key]).forEach(subKey => {
                        const input = document.createElement('input');
                        input.type = 'hidden';
                        input.name = `${key}[${subKey}]`;
                        input.value = datos[key][subKey];
                        form.appendChild(input);
                    });
                } else {
                    const input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = key;
                    input.value = datos[key];
                    form.appendChild(input);
                }
            });

            // Agregar formulario al DOM y enviarlo
            document.body.appendChild(form);
            form.submit();
            document.body.removeChild(form);
        }

        // Obtener todos los datos del formulario
        function obtenerDatosArqueo() {
            const datos = {
                id_usuario: <?php echo $id_usuario; ?>,
                usuario: "<?php echo addslashes($nombre_usuario); ?>",
                monto_virtual: document.getElementById('monto_virtual').value,
                num_turno: document.getElementById('num_turno').value,
                observaciones: document.getElementById('observaciones').value,
                fecha_actual: document.getElementById('fecha-actual').textContent,
                hora_actual: document.getElementById('hora-actual').textContent
            };

            // Agregar datos de denominaciones
            const denominacionesData = {};
            denominaciones.forEach(denom => {
                denominacionesData[denom.id] = document.getElementById(denom.id).value;
            });
            datos.denominaciones = denominacionesData;

            // Calcular y agregar totales
            datos.totales = calcularTotales();

            return datos;
        }

        // Limpiar formulario (opcional)
        function limpiarFormulario() {
            document.querySelectorAll('.cantidad-denominacion').forEach(input => {
                input.value = '0';
            });
            document.getElementById('monto_virtual').value = '0.00';
            document.getElementById('observaciones').value = '';
            calcularTotales();
        }

        // Actualizar hora actual
        function actualizarHora() {
            const ahora = new Date();
            const hora = ahora.getHours().toString().padStart(2, '0');
            const minutos = ahora.getMinutes().toString().padStart(2, '0');
            const segundos = ahora.getSeconds().toString().padStart(2, '0');
            document.getElementById('hora-actual').textContent = `${hora}:${minutos}:${segundos}`;
        }

        // Inicializar
        document.addEventListener('DOMContentLoaded', function () {
            generarCamposDenominaciones();
            calcularTotales();
            actualizarHora();
            setInterval(actualizarHora, 1000);

            // Autocalcular al cargar
            denominaciones.forEach(denom => {
                calcularSubtotal(denom.id);
            });
        });
    </script>
</body>

</html>