<?php
// Recibir datos JSON del formulario
$data = json_decode(file_get_contents('php://input'), true);

// Conexión a la base de datos (ajusta con tus credenciales)
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "yoveraes_botica";

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Calcular montos
    $valores = [
        'li_m1' => 0.10,
        'li_m2' => 0.20,
        'li_m3' => 0.50,
        'li_m4' => 1.00,
        'li_m5' => 2.00,
        'li_m6' => 5.00,
        'li_m7' => 10.00,
        'li_m8' => 20.00,
        'li_m9' => 50.00,
        'li_m10' => 100.00,
        'li_m11' => 200.00
    ];

    $monto_efectivo = 0;
    foreach ($valores as $key => $valor) {
        if (isset($data['denominaciones'][$key])) {
            $monto_efectivo += $data['denominaciones'][$key] * $valor;
        }
    }

    $monto_virtual = floatval($data['monto_virtual'] ?? 0);
    $total = $monto_efectivo + $monto_virtual;

    // Preparar consulta SQL
    $sql = "INSERT INTO arqueo_caja (
        li_m1, li_m2, li_m3, li_m4, li_m5, li_m6, li_m7, li_m8, li_m9, li_m10, li_m11,
        idusuario, correo, Fecha_cierre, Hora_cierre, Monto_Virtual, Monto_Efectivo,
        Num_turno, Total, Observaciones
    ) VALUES (
        :m1, :m2, :m3, :m4, :m5, :m6, :m7, :m8, :m9, :m10, :m11,
        :id_usuario, :usuario, CURDATE(), CURTIME(), :monto_virtual, :monto_efectivo,
        :num_turno, :total, :observaciones
    )";

    $stmt = $conn->prepare($sql);

    // Parámetros
    $params = [
        ':m1' => $data['denominaciones']['li_m1'] ?? 0,
        ':m2' => $data['denominaciones']['li_m2'] ?? 0,
        ':m3' => $data['denominaciones']['li_m3'] ?? 0,
        ':m4' => $data['denominaciones']['li_m4'] ?? 0,
        ':m5' => $data['denominaciones']['li_m5'] ?? 0,
        ':m6' => $data['denominaciones']['li_m6'] ?? 0,
        ':m7' => $data['denominaciones']['li_m7'] ?? 0,
        ':m8' => $data['denominaciones']['li_m8'] ?? 0,
        ':m9' => $data['denominaciones']['li_m9'] ?? 0,
        ':m10' => $data['denominaciones']['li_m10'] ?? 0,
        ':m11' => $data['denominaciones']['li_m11'] ?? 0,
        ':id_usuario' => $data['idusuario'],
        ':usuario' => $data['correo'],
        ':monto_virtual' => $monto_virtual,
        ':monto_efectivo' => $monto_efectivo,
        ':num_turno' => $data['num_turno'] ?? 1,
        ':total' => $total,
        ':observaciones' => $data['observaciones'] ?? ''
    ];

    if ($stmt->execute($params)) {
        $id_cierre = $conn->lastInsertId();
        echo json_encode([
            'success' => true,
            'id_cierre' => $id_cierre,
            'message' => 'Arqueo guardado exitosamente'
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Error al guardar en la base de datos'
        ]);
    }

} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error de conexión: ' . $e->getMessage()
    ]);
}
?>