<?php
session_start();
require('fpdf/fpdf.php');
$conn = new mysqli('localhost', 'yoveraes_userdb', 't7@s5FxYn1GB', 'yoveraes_botica');
$id_venta = $_GET['id_venta']; // ID de la venta que deseas imprimir

// Obtener los datos de la venta
$sql_venta = "SELECT * FROM ventas WHERE id = ?";
$stmt = $conn->prepare($sql_venta);
$stmt->bind_param('i', $id_venta);
$stmt->execute();
$venta = $stmt->get_result()->fetch_assoc();
$stmt->close();

// Obtener los detalles de la venta
$sql_detalles = "SELECT p.nombre, d.cantidad, d.precio, p.presentacion
                 FROM detalle_ventas d
                 INNER JOIN producto p ON d.id_producto = p.id
                 WHERE d.id_venta = ?";
$stmt = $conn->prepare($sql_detalles);
$stmt->bind_param('i', $id_venta);
$stmt->execute();
$detalles = $stmt->get_result();

// Crear PDF
$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 12);

// Encabezado
$pdf->Cell(0, 10, 'Boleta de Venta', 0, 1, 'C');
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(0, 10, 'Cliente: ' . $venta['cliente'], 0, 1);
$pdf->Cell(0, 10, 'Metodo de Pago: ' . $venta['metodo'], 0, 1);
$pdf->Cell(0, 10, 'Fecha: ' . $venta['fecha'], 0, 1);
$pdf->Ln(10);

// Tabla de productos
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(80, 10, 'Producto', 1);
$pdf->Cell(30, 10, 'Presentacion', 1);
$pdf->Cell(30, 10, 'Cantidad', 1);
$pdf->Cell(30, 10, 'Precio', 1);
$pdf->Cell(30, 10, 'Subtotal', 1);
$pdf->Ln();

$total = 0;
$pdf->SetFont('Arial', '', 10);

while ($detalle = $detalles->fetch_assoc()) {
    $subtotal = $detalle['cantidad'] * $detalle['precio'];
    $total += $subtotal;

    $pdf->Cell(80, 10, $detalle['nombre'], 1);
    $pdf->Cell(30, 10, $detalle['presentacion'], 1);
    $pdf->Cell(30, 10, $detalle['cantidad'], 1);
    $pdf->Cell(30, 10, number_format($detalle['precio'], 2), 1);
    $pdf->Cell(30, 10, number_format($subtotal, 2), 1);
    $pdf->Ln();
}

// Total
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(170, 10, 'Total', 1);
$pdf->Cell(30, 10, number_format($total, 2), 1);

$pdf->Output();
?>