<?php
session_start();
require('fpdf/fpdf.php');
$conn = new mysqli('localhost', 'yoveraes_userdb', 't7@s5FxYn1GB', 'yoveraes_botica');

$id_venta = $_GET['id']; // ID de la venta que deseas imprimir

function numero_a_letras($numero)
{
    $numeros = array(
        0 => 'Cero',
        1 => 'Uno',
        2 => 'Dos',
        3 => 'Tres',
        4 => 'Cuatro',
        5 => 'Cinco',
        6 => 'Seis',
        7 => 'Siete',
        8 => 'Ocho',
        9 => 'Nueve',
        10 => 'Diez',
        11 => 'Once',
        12 => 'Doce',
        13 => 'Trece',
        14 => 'Catorce',
        15 => 'Quince',
        16 => 'Dieciséis',
        17 => 'Diecisiete',
        18 => 'Dieciocho',
        19 => 'Diecinueve',
        20 => 'Veinte',
        30 => 'Treinta',
        40 => 'Cuarenta',
        50 => 'Cincuenta',
        60 => 'Sesenta',
        70 => 'Setenta',
        80 => 'Ochenta',
        90 => 'Noventa',
        100 => 'Cien',
        200 => 'Doscientos',
        300 => 'Trescientos',
        400 => 'Cuatrocientos',
        500 => 'Quinientos',
        600 => 'Seiscientos',
        700 => 'Setecientos',
        800 => 'Ochocientos',
        900 => 'Novecientos'
    );

    $decimal = "";
    $parte_decimal = "";

    // Si tiene parte decimal
    if (strpos($numero, '.') !== false) {
        list($numero, $decimal) = explode('.', $numero);
    }
    // Convertir parte entera
    if ($numero < 21) {
        $parte_decimal = $numeros[$numero];
    } else if ($numero < 100) {
        $decenas = floor($numero / 10) * 10;
        $unidad = $numero % 10;
        $parte_decimal = $numeros[$decenas];
        if ($unidad > 0) {
            $parte_decimal .= ' y ' . $numeros[$unidad];
        }
    } else if ($numero >= 100) {
        $centenas = floor($numero / 100) * 100;
        $resto = $numero % 100;
        $parte_decimal = $numeros[$centenas];
        if ($resto > 0) {
            $parte_decimal .= ' ' . numero_a_letras($resto);
        }
    }
    return $parte_decimal . ($decimal ? ' con ' . $decimal . '/100 SOLES' : '');
}
date_default_timezone_set('America/Lima');
$hora_actual = date('H:i:s');
// Obtener los datos de la venta
$sql_venta = "SELECT * FROM ventas WHERE id = ?";
$stmt = $conn->prepare($sql_venta);
$stmt->bind_param('i', $id_venta);
$stmt->execute();
$venta = $stmt->get_result()->fetch_assoc();
$stmt->close();

// Obtener los detalles de la venta
$sql_detalles = "SELECT p.descripcion, d.cantidad, d.precio, p.presentacion
                 FROM detalle_ventas d
                 INNER JOIN producto p ON d.id_producto= p.codproducto
                 WHERE d.id_venta = ?";
$stmt = $conn->prepare($sql_detalles);
$stmt->bind_param('i', $id_venta);
$stmt->execute();
$detalles = $stmt->get_result();

// Crear PDF
$pdf = new FPDF('P', 'mm', array(80, 300));
$pdf->AddPage();
$pdf->SetMargins(5, 5, 5);
$pdf->SetFont('Arial', 'B', 9);

// Agregar logo
$pdf->Image('img/logo.png', 15, 2, 45);
$pdf->SetFont('Times', 'B', 9);
$pdf->Image('img/logo.png', 5, 1, 50); //logo de la empresa,moverDerecha,moverAbajo,tamañoIMG
$pdf->SetFont('Arial', 'B', 8); //tipo fuente, negrita(B-I-U-BIU), tamañoTexto
$pdf->ln(-8); // Movernos a la derecha
$pdf->Cell(25); // Movernos a la derecha
$pdf->SetTextColor(0, 0, 0); //color
$pdf->Cell(20, 50, 'R.U.C. 20613134752', 0, 1, 'C', 0);
$pdf->Ln(-22);

/* RUC */
$pdf->Cell(20);  // mover a la derecha
$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(45, 1, mb_convert_encoding("BOTICA VIRGEN DE GUADALUPE", 'ISO-8859-1'), 0, 0, 'R', 0);
$pdf->Ln(2);
/* SERVICIO */
$pdf->Cell(25);  // mover a la derecha
$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(1, 5, mb_convert_encoding("Telef.: 947591992", 'ISO-8859-1'), 0, 0, '', 0);
$pdf->Ln(1);
/* SERVICIO */

// Encabezado
$pdf->Cell(0, 8, 'Boleta de Venta', 0, 1, 'C');
$pdf->SetFont('Arial', '', 8);
$pdf->Cell(0, 8, 'Cliente: ' . $venta['cliente'], 0, 1);
$pdf->Cell(0, 8, 'Metodo de Pago : ' . $venta['metodo'], 0, 1);
$pdf->Cell(0, 8, 'Fecha : ' . $venta['fecha'], 0, 1);
$pdf->Cell(0, 8, 'Direccion : ' . $venta['direccion'], 0, 1);
$pdf->Ln(-1);
$pdf->Cell(25);  // mover a la derecha
$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(0, -47, mb_convert_encoding($venta['num_docpe'], 'ISO-8859-1'), 0, 0, '', 0);
$pdf->Ln(-1);
$pdf->SetDrawColor(0, 0, 0);
$pdf->Ln(2);

$pdf->Line(0, $pdf->GetY(), 200, $pdf->GetY());
$pdf->Ln(1);
$pdf->SetFont('Arial', 'B', 11);
$pdf->Cell(20, 5, mb_convert_encoding('Cant - Precio: ', 'ISO-8859-1'), 0, 0, 'C');
$pdf->Cell(40, 5, mb_convert_encoding('Producto: ', 'ISO-8859-1'), 0, 1, 'C');
$pdf->SetFont('Arial', '', 11);
$pdf->Ln(1);
$pdf->Line(0, $pdf->GetY(), 200, $pdf->GetY());

$total = 0;
$pdf->SetFont('Arial', '', 8);

while ($detalle = $detalles->fetch_assoc()) {
    $subtotal = $detalle['cantidad'] * $detalle['precio'];
    $total += $subtotal;

    $pdf->Cell(20, 5, $detalle['cantidad'] . ' x ' . $detalle['precio'], 0, 0, 'C');
    $pdf->MultiCell(40, 5, $detalle['descripcion'], 0, 'C');
    $pdf->Cell(80, 5, 'SubTotal S/.' . number_format($detalle['cantidad'] * $detalle['precio'], 2), 0, 1, 'R');
    $pdf->Ln(1);
}
$pdf->Ln(2);
$pdf->Line(0, $pdf->GetY(), 200, $pdf->GetY());
// Total
$pdf->Ln(5);
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(0, 0, 'TOTAL S/                                   ' . number_format($total, 2), 0);

$pdf->Ln(3);
$pdf->SetFont('Arial', 'B', 8); // Negrita
$pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
$texto6e = mb_convert_encoding("AGRADECEMOS SU PREFERENCIA VUELVA PRONTO!!!", 'ISO-8859-1');
$texto6f = ' ';
$pdf->SetFont('Arial', '', 7); // Texto negrita
$pdf->Write(3, $texto6e);
$pdf->SetFont('Arial', '', 7); // Texto normal
$pdf->Write(3, $texto6f);

$pdf->Image('img/barcode.png', 30, 115, 20); //logo de la empresa,moverDerecha,moverAbajo,tamañoIMG
$pdf->Output();
?>