<?php
// Si no usas FPDF, aquí tienes una versión HTML simple
header('Content-Type: text/html; charset=utf-8');

// Recibir datos POST
$id_usuario = $_POST['idusuario'] ?? 'N/A';
$usuario = $_POST['idusuario'] ?? 'Usuario';
$num_turno = $_POST['num_turno'] ?? 1;
$observaciones = $_POST['observaciones'] ?? '';
$fecha = $_POST['fecha_actual'] ?? date('d/m/Y');
$hora = $_POST['hora_actual'] ?? date('H:i:s');

// Calcular totales desde POST
$denominaciones = $_POST['denominaciones'] ?? [];
$totales = $_POST['totales'] ?? ['efectivo' => 0, 'virtual' => 0, 'total' => 0];

// Valores de denominaciones
$valores = [
    'li_m1' => ['desc' => 'Moneda $0.05', 'valor' => 0.05],
    'li_m2' => ['desc' => 'Moneda $0.10', 'valor' => 0.10],
    'li_m3' => ['desc' => 'Moneda $0.20', 'valor' => 0.20],
    'li_m4' => ['desc' => 'Moneda $0.50', 'valor' => 0.50],
    'li_m5' => ['desc' => 'Moneda $1.00', 'valor' => 1.00],
    'li_m6' => ['desc' => 'Moneda $2.00', 'valor' => 2.00],
    'li_m7' => ['desc' => 'Moneda $5.00', 'valor' => 5.00],
    'li_m8' => ['desc' => 'Billete $10.00', 'valor' => 10.00],
    'li_m9' => ['desc' => 'Billete $20.00', 'valor' => 20.00],
    'li_m10' => ['desc' => 'Billete $50.00', 'valor' => 50.00],
    'li_m11' => ['desc' => 'Billete $100.00', 'valor' => 100.00]
];
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Arqueo</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }

        .header {
            text-align: center;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }

        .info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: center;
        }

        th {
            background-color: #f2f2f2;
        }

        .total-row {
            background-color: #e8f4ff;
            font-weight: bold;
        }

        .totals {
            display: flex;
            justify-content: space-around;
            margin: 20px 0;
        }

        .total-box {
            border: 2px solid #333;
            padding: 15px;
            text-align: center;
            min-width: 200px;
        }

        .footer {
            margin-top: 40px;
            text-align: center;
        }

        .signature {
            margin-top: 50px;
            border-top: 1px solid #333;
            width: 300px;
            text-align: center;
            padding-top: 10px;
        }

        @media print {
            button {
                display: none;
            }
        }
    </style>
</head>

<body>
    <div class="header">
        <h1>REPORTE DE ARQUEO DE CAJA</h1>
        <h3><?php echo $fecha . ' - ' . $hora; ?></h3>
    </div>

    <div class="info">
        <div>
            <strong>Usuario:</strong> <?php echo htmlspecialchars($usuario); ?><br>
            <strong>ID Usuario:</strong> <?php echo $id_usuario; ?>
        </div>
        <div>
            <strong>Turno:</strong> <?php echo $num_turno; ?><br>
            <strong>Fecha Generación:</strong> <?php echo date('d/m/Y H:i:s'); ?>
        </div>
    </div>

    <h3>Detalle de Monedas y Billetes</h3>
    <table>
        <thead>
            <tr>
                <th>Denominación</th>
                <th>Cantidad</th>
                <th>Valor Unitario</th>
                <th>Subtotal</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $total_efectivo = 0;
            foreach ($valores as $key => $info):
                $cantidad = $denominaciones[$key] ?? 0;
                $subtotal = $cantidad * $info['valor'];
                $total_efectivo += $subtotal;
                if ($cantidad > 0):
                    ?>
                    <tr>
                        <td><?php echo $info['desc']; ?></td>
                        <td><?php echo $cantidad; ?></td>
                        <td>S/. <?php echo number_format($info['valor'], 2); ?></td>
                        <td>S/. <?php echo number_format($subtotal, 2); ?></td>
                    </tr>
                    <?php
                endif;
            endforeach;
            ?>
        </tbody>
    </table>

    <div class="totals">
        <div class="total-box">
            <h4>Total Efectivo</h4>
            <h2>S/. <?php echo number_format($total_efectivo, 2); ?></h2>
        </div>
        <div class="total-box">
            <h4>Total Virtual</h4>
            <h2>S/. <?php echo number_format($totales['virtual'], 2); ?></h2>
        </div>
        <div class="total-box">
            <h4>Gran Total</h4>
            <h2>S/. <?php echo number_format($total_efectivo + $totales['virtual'], 2); ?></h2>
        </div>
    </div>

    <?php if (!empty($observaciones)): ?>
        <div>
            <h3>Observaciones:</h3>
            <p><?php echo nl2br(htmlspecialchars($observaciones)); ?></p>
        </div>
    <?php endif; ?>

    <div class="footer">
        <div class="signature">
            <p>___________________________</p>
            <p>Firma del Responsable</p>
        </div>

        <button onclick="window.print()" style="margin-top: 20px; padding: 10px 20px;">
            🖨️ Imprimir Reporte
        </button>
    </div>
</body>

</html>