<?php
session_start();
require('fpdf/fpdf.php');

// Conexión a la base de datos
$host = 'localhost';
$dbname = 'yoveraes_botica';
$username ='yoveraes_userdb';
$password ='t7@s5FxYn1GB';
try {
    $conn = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Error de conexión: " . $e->getMessage());
}

// Obtener la fecha del reporte desde GET o fecha actual
$fecha = $_GET['fecha'] ?? date('Y-m-d');

// Consulta SQL para obtener las ventas del día
$query = "SELECT fecha, num_docpe, total, cliente, metodo, hora_vtap FROM ventas WHERE fecha = :fecha AND correo='$_SESSION[correo]' ORDER BY num_docpe";

$stmt = $conn->prepare($query);
$stmt->bindParam(':fecha', $fecha);
$stmt->execute();
$ventas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Definir clase PDF extendida
class PDF extends FPDF
{
    // Encabezado
    function Header()
    {
        $this->SetFont('Arial', 'B', 14);
        $this->Cell(152, 10, "Reporte de Ventas - Caja Diaria", 0, 1, 'C');
        $this->SetFont('Arial', '', 12);
        $this->Cell(152, 8, "Fecha: " . $_GET['fecha'] . '       Usuario: ' . $_SESSION['correo'], 0, 1, 'C');
        $this->Ln(2);
    }
    // Pie de página
    function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('Arial', 'B', 9);
        $this->Cell(280, 0, '', 'T', 1, 'C'); // Línea separadora
        $this->Cell(170, 10, 'FIRMA CAJERO                                                          RECIBI CONFORME', 0, 0, 'C');
        $this->Cell(25, 10, mb_convert_encoding('Página ', 'ISO-8859-1') . $this->PageNo() . '/{nb}', 0, 0, 'R');
    }
}

// Crear PDF en A4 Horizontal
$pdf = new PDF('P', 'mm', 'A4');
//$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetMargins(10, 0, 0);
$pdf->SetFont('Arial', 'B', 9);

// Definir anchos de columnas
$column_widths = [
    7,
    20,
    20,
    15,
    50,
    20,
    20
];
// Encabezados
$headers = ['Id.', 'Fecha Venta', 'Documento', 'H.Venta', 'Cliente', 'Forma Pago', 'Monto S/.'];
$pdf->SetFont('Arial', 'B', 8);
$pdf->SetFillColor(200, 200, 200);
foreach ($headers as $i => $header) {
    $pdf->Cell($column_widths[$i], 5, $header, 1, 0, 'C', true);
}
$pdf->Ln();
// Variables para totalizar montos por método de pago
$totalGeneral = 0;
$totalesMetodos = ['CONTADO' => 0, 'TRANSFERENCIA' => 0, 'YAPE' => 0, 'PLIN' => 0, 'OTRO' => 0];

$pdf->SetFont('Arial', '', 8);
$id_correlativo = 1;
// Llenar tabla con datos
foreach ($ventas as $venta) {
    $pdf->Cell($column_widths[0], 5, $id_correlativo++, 1, 0, 'C'); // ID
    $pdf->Cell($column_widths[1], 5, $venta['fecha'], 1, 0, 'C');
    $pdf->Cell($column_widths[2], 5, $venta['num_docpe'], 1, 0, 'C');
    $pdf->Cell($column_widths[3], 5, $venta['hora_vtap'], 1, 0, 'C');
    $pdf->Cell($column_widths[4], 5, mb_convert_encoding($venta['cliente'], 'ISO-8859-1'), 1, 0, 'L');
    $pdf->Cell($column_widths[5], 5, $venta['metodo'], 1, 0, 'C');
    $pdf->Cell($column_widths[6], 5, number_format($venta['total'], 2), 1, 0, 'R');
    // Sumar montos por método de pago
    $totalesMetodos[$venta['metodo']] += $venta['total'];
    $totalGeneral += $venta['total'];
    $pdf->Ln();
}

// Espaciado antes del resumen de totales
$pdf->Ln(5);

// Tabla de totales por método de pago
$pdf->SetFont('Arial', 'B', 9);
$pdf->SetFillColor(180, 180, 180);
$pdf->Cell(45, 6, 'Metodo de Pago', 1, 0, 'C', true);
$pdf->Cell(25, 6, 'Total', 1, 1, 'C', true);

$pdf->SetFont('Arial', '', 9);
foreach ($totalesMetodos as $metodo => $monto) {
    $pdf->Cell(45, 6, $metodo, 1, 0, 'C');
    $pdf->Cell(25, 6, number_format($monto, 2), 1, 1, 'R');
}

// Total general
$pdf->SetFont('Arial', 'B', 11);
$pdf->SetFillColor(220, 220, 220);
$pdf->Cell(45, 6, 'TOTAL GENERAL', 1, 0, 'C', true);
$pdf->Cell(25, 6, number_format($totalGeneral, 2), 1, 1, 'R', true);

// Salida del PDF
$pdf->Output("Reporte_Caja_$fecha.pdf", 'I'); // Mostrar en el navegador
?>