<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

//session_start();
require('conexionn.php');
require('fpdf/fpdf.php'); // Asegúrate de tener FPDF en tu proyecto

// Obtener datos desde la URL
$id = isset($_GET['id']) ? $_GET['id'] : '';
$tipo_pago = isset($_GET['tipo_pago']) ? $_GET['tipo_pago'] : '';
$formato = isset($_GET['formato']) ? $_GET['formato'] : '';
// Validar si se recibió un ID
if (empty($id) || empty($formato)) {
    die("❌ No se recibió un ID válido.");
}
function numero_a_letras($numero)
{
    $unidades = ['', 'UNO', 'DOS', 'TRES', 'CUATRO', 'CINCO', 'SEIS', 'SIETE', 'OCHO', 'NUEVE'];
    $decenas = ['', 'DIEZ', 'VEINTE', 'TREINTA', 'CUARENTA', 'CINCUENTA', 'SESENTA', 'SETENTA', 'OCHENTA', 'NOVENTA'];
    $especiales = [
        11 => 'ONCE',
        12 => 'DOCE',
        13 => 'TRECE',
        14 => 'CATORCE',
        15 => 'QUINCE',
        16 => 'DIECISÉIS',
        17 => 'DIECISIETE',
        18 => 'DIECIOCHO',
        19 => 'DIECINUEVE',
        21 => 'VEINTIUNO',
        22 => 'VEINTIDÓS',
        23 => 'VEINTITRÉS',
        24 => 'VEINTICUATRO',
        25 => 'VEINTICINCO',
        26 => 'VEINTISÉIS',
        27 => 'VEINTISIETE',
        28 => 'VEINTIOCHO',
        29 => 'VEINTINUEVE'
    ];
    $centenas = [
        '',
        'CIENTO',
        'DOSCIENTOS',
        'TRESCIENTOS',
        'CUATROCIENTOS',
        'QUINIENTOS',
        'SEISCIENTOS',
        'SETECIENTOS',
        'OCHOCIENTOS',
        'NOVECIENTOS'
    ];

    if ($numero == 0)
        return 'CERO CON 00/100 SOLES';

    // Separamos la parte entera y decimal
    $partes = explode('.', number_format($numero, 2, '.', ''));
    $num = (int) $partes[0]; // Parte entera
    $decimales = str_pad($partes[1], 2, '0', STR_PAD_RIGHT); // Decimales con 2 dígitos
    $letras = '';

    if ($num >= 1000) {
        $mil = floor($num / 1000);
        $resto = $num % 1000;
        if ($mil == 1) {
            $letras .= "MIL ";
        } else {
            $letras .= numero_a_letras($mil) . " MIL ";
        }
        $num = $resto;
    }

    if ($num >= 100) {
        $cen = floor($num / 100);
        $num = $num % 100;
        if ($cen == 1 && $num == 0) {
            $letras .= "CIEN ";
        } else {
            $letras .= $centenas[$cen] . " ";
        }
    }

    if ($num >= 10 && $num <= 29) {
        $letras .= $especiales[$num] . " ";
        $num = 0;
    } elseif ($num >= 30) {
        $dec = floor($num / 10);
        $num = $num % 10;
        $letras .= $decenas[$dec];
        if ($num > 0) {
            $letras .= " Y " . $unidades[$num];
        }
    } elseif ($num > 0) {
        $letras .= $unidades[$num];
    }

    return trim($letras) . " CON {$decimales}/100 SOLES";
}
// Obtener datos del pedido
$sql = "SELECT v.num_docpe, v.fecha, v.metodo, v.cliente, v.direccion, v.doc_ident, p.descripcion , d.cantidad, d.precio
        FROM ventas v
        JOIN detalle_ventas d ON v.id = d.id_venta
        JOIN producto p ON d.id_producto = p.codproducto
                WHERE v.id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows == 0) {
    die("❌ No se encontró el pedido.");
}
// Extraer datos
$venta = [];
while ($row = $result->fetch_assoc()) {
    $venta[] = $row;
}
$stmt->close();
$conn->close();
// **📌 Definir formato del PDF según tipo de documento**
if ($formato === "B") {
    $pdf = new FPDF('P', 'mm', array(80, 300)); // Ticket pequeño
    $pdf->AddPage();
    $pdf->SetMargins(5, 5, 5);
    $pdf->SetFont('Arial', 'B', 9);
    // **📌 CABECERA DEL DOCUMENTO**
    // Agregar logo
    $pdf->SetFont('Times', 'B', 9);
    //$pdf->Image('/img/logo.jpeg', 5, 1, 40); //logo de la empresa,moverDerecha,moverAbajo,tamañoIMG
    // Ruta absoluta al archivo logo
    $logoPath = $_SERVER['DOCUMENT_ROOT'] . '/Botica/views/ventas/img/Logo.png';
    // Verificar si existe
    if (file_exists($logoPath)) {
        $pdf->Image($logoPath, 5, 1, 40); // x, y, ancho
    } else {
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->SetTextColor(255, 0, 0);
        $pdf->Cell(0, 10, '⚠ Logo no encontrado: ' . $logoPath, 0, 1);
    }
    $pdf->SetFont('Arial', 'B', 8); //tipo fuente, negrita(B-I-U-BIU), tamañoTexto
    $pdf->ln(-15); // Movernos a la derecha
    $pdf->Cell(25); // Movernos a la derecha
    $pdf->SetTextColor(0, 0, 0); //color
    $pdf->Cell(20, 50, 'R.U.C. 20608279718', 0, 1, 'C', 0);
    $pdf->Ln(-22);
    /* RUC */
    $pdf->Cell(20);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(45, 1, mb_convert_encoding("BOTICA VIRGEN DE GUADALUPE", 'ISO-8859-1'), 0, 0, 'R', 0);
    $pdf->Ln(1);
    $pdf->Cell(20);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(1, 5, mb_convert_encoding("Telef.: (+51)960 879 247", 'ISO-8859-1'), 0, 0, '', 0);
    $pdf->Ln(5);
    /*DOCUMENTO*/
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, mb_convert_encoding("BOLETA DE VENTA ELECTRONICA", 'ISO-8859-1'), 0, 0, 'C', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Ln(-1);
    $pdf->Cell(25);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(1, 15, mb_convert_encoding($venta[0]['num_docpe'], 'ISO-8859-1'), 0, 0, 'L', 0);
    $pdf->Ln(2);
    $pdf->SetDrawColor(0, 0, 0);
    $pdf->Ln(10);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->Ln(-5);
    // **📌 Información del Cliente**
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, ''); // Avanzar línea para posicionar
    $texto1a = mb_convert_encoding("Fecha de Emisión :", 'ISO-8859-1');
    $texto1b = ' ' . $venta[0]['fecha'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5, $texto1a);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5, $texto1b);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, ''); // Avanzar línea para posicionar
    $texto1c = mb_convert_encoding("Cliente : ", 'ISO-8859-1');
    $texto1d = ' ' . $venta[0]['cliente'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5, $texto1c);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5, $texto1d);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto1e = mb_convert_encoding("Dirección :", 'ISO-8859-1');
    $texto1f = ' ' . $venta[0]['direccion'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5.5, $texto1e);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5.5, $texto1f);
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto1g = mb_convert_encoding("Forma de Pago :", 'ISO-8859-1');
    $texto1h = ' ' . $venta[0]['metodo'];
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5.5, $texto1g);
    $pdf->SetFont('Arial', '', 8); // Texto normal
    $pdf->Write(5.5, $texto1h);
    $pdf->Ln(5);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    // **📌 TABLA DE DETALLES**
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(20, 5, "Cant - Precio", 0, 0, 'C');
    $pdf->Cell(40, 5, "Producto", 0, 0, 'C');
    $pdf->Cell(20, 5, "Total", 0, 0, 'L');
    $pdf->Ln(5);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->Ln(1);
    $pdf->SetFont('Arial', '', 8);
    $total = 0;
    foreach ($venta as $item) {
        $subtotal = $item['cantidad'] * $item['precio'];
        $total += $subtotal;
        $pdf->Cell(20, 5, $item['cantidad'] . ' x ' . $item['precio'], 0, 0, 'C');
        $pdf->MultiCell(50, 5, $item['descripcion'], 0, 'L');
        $pdf->Cell(80, 5, '                                                 SubTotal S/.  ' . number_format($item['cantidad'] * $item['precio'], 2), 0, 1, 'C');
        //$total += $item['cantidad'] * $item['precio'];
    }
    $pdf->Ln(2);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    // **📌 TOTAL**
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(50, 6, "TOTAL:", 0, 0, 'R');
    $pdf->Cell(20, 6, "S/ " . number_format($total, 2, '.', ','), 0, 0, 'R');
    $pdf->Ln(3);
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto5g = mb_convert_encoding("SON :", 'ISO-8859-1');
    $total_venta = $total;
    $total_venta_letras = ' ' . numero_a_letras($total_venta);
    $pdf->SetFont('Arial', 'B', 7); // Texto negrita
    $pdf->Write(4.5, $texto5g);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(4.5, strtoupper($total_venta_letras));
    $pdf->Ln(4);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto6e = mb_convert_encoding("AGRADECEMOS SU PREFERENCIA VUELVA PRONTO!!!", 'ISO-8859-1');
    $texto6f = ' ';
    $pdf->SetFont('Arial', '', 7); // Texto negrita
    $pdf->Write(3, $texto6e);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(3, $texto6f);
    $posY = $pdf->GetY() + 5; // Ajusta la posición en función del contenido
    $pdf->Image('img/barcode.png', 27, $posY, 28); //logo de la empresa,moverDerecha,moverAbajo,tamañoIMG
    // **📌 Salida del PDF**
    $pdf->Output("I", $venta[0]['num_docpe'] . ".pdf");
}
if ($formato === "F") {
    $pdf = new FPDF('P', 'mm', 'A4'); // Factura en tamaño A4
    $pdf->AddPage();
    $pdf->SetMargins(5, 5, 5);
    $pdf->SetFont('Arial', 'B', 9);
    // **📌 CABECERA DEL DOCUMENTO**
    // Agregar logo
    $pdf->SetFont('Times', 'B', 11);
    //$pdf->Image('img/logo.jpeg', 5, 5, 60); //logo de la empresa,moverDerecha,moverAbajo,tamañoIMG
    $logoPath = $_SERVER['DOCUMENT_ROOT'] . '/Botica/views/ventas/img/Logo.png';
    // Verificar si existe
    if (file_exists($logoPath)) {
        $pdf->Image($logoPath, 5, 1, 40); // x, y, ancho
    } else {
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->SetTextColor(255, 0, 0);
        $pdf->Cell(0, 10, '⚠ Logo no encontrado: ' . $logoPath, 0, 1);
    }
    $pdf->SetFont('Arial', 'B', 11); //tipo fuente, negrita(B-I-U-BIU), tamañoTexto
    $pdf->ln(-5); // Movernos a la derecha
    $pdf->Cell(150); // Movernos a la derecha
    $pdf->SetTextColor(0, 0, 0); //color
    $pdf->Cell(0, 10, mb_convert_encoding('R.U.C. N° 20608279718', 'ISO-8859-1'), 1, 0, 'C', 0);
    $pdf->Ln(7);
    /* RUC */
    $pdf->Cell(20);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 11);
    $pdf->Cell(40);  // mover a la derecha
    $pdf->Cell(80, 5, mb_convert_encoding("BOTICA VIRGEN DE GUADALUPE", 'ISO-8859-1'), 0, 0, 'L', 0);
    $pdf->Ln(5.5);
    $pdf->Cell(60);  // mover a la derecha
    $pdf->SetFont('Arial', '', 7);
    $pdf->MultiCell(90, 3, mb_convert_encoding("OFICINA.: CAL.1 MZA. R LOTE. 13 RES. PUERTAS DEL SOL - CHACUPE LAMBAYEQUE - CHICLAYO - CHICLAYO", 'ISO-8859-1'), 0, 'L');
    $pdf->Ln(-1.2);
    $pdf->Cell(60);  // mover a la derecha
    $pdf->Cell(25, 5, mb_convert_encoding("Telef.: (+51)960 879 247", 'ISO-8859-1'), 0, 0, 'L', 0);
    /*DOCUMENTO*/
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Ln(-7.3);
    $pdf->Cell(150);  // mover a la derecha
    $pdf->SetFillColor(169, 169, 169);
    $pdf->Cell(50, 5, mb_convert_encoding("FACTURA ELECTRONICA", 'ISO-8859-1'), 1, 1, 'C', 1);
    $pdf->SetFont('Arial', '', 10);
    $pdf->Ln(-0.1);
    $pdf->Cell(150);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetTextColor(255, 0, 0); // Rojo (Texto)
    $pdf->Cell(0, 7, mb_convert_encoding($venta[0]['num_docpe'], 'ISO-8859-1'), 1, 0, 'C', 0);
    $pdf->Ln(2);
    $pdf->SetTextColor(0, 0, 0); // Rojo (Texto)
    $pdf->SetDrawColor(0, 0, 0);
    $pdf->Ln(13);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->Ln(-5);
    // **📌 Información del Cliente**
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, ''); // Avanzar línea para posicionar
    $texto1a = mb_convert_encoding("Fecha de Emisión :", 'ISO-8859-1');
    $texto1b = ' ' . $venta[0]['fecha'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5, $texto1a);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5, $texto1b);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, ''); // Avanzar línea para posicionar
    $texto1a = mb_convert_encoding("R.U.C. :", 'ISO-8859-1');
    $texto1b = ' ' . $venta[0]['doc_ident'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5, $texto1a);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5, $texto1b);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, ''); // Avanzar línea para posicionar
    $texto1c = mb_convert_encoding("SEÑOR(ES) : ", 'ISO-8859-1');
    $texto1d = ' ' . $venta[0]['cliente'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5, $texto1c);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5, $texto1d);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto1e = mb_convert_encoding("DOMICILIO FISCAL :", 'ISO-8859-1');
    $texto1f = ' ' . $venta[0]['direccion'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5.5, $texto1e);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5.5, $texto1f);
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto1g = mb_convert_encoding("FORMA DE PAGO :", 'ISO-8859-1');
    $texto1h = ' ' . $venta[0]['metodo'];
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5.5, $texto1g);
    $pdf->SetFont('Arial', '', 8); // Texto normal
    $pdf->Write(5.5, $texto1h);
    $pdf->Ln(5);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->Ln(2);
    // **📌 TABLA DE DETALLES**
    $pdf->SetFont('Arial', 'B', 9);
    $pdf->SetFillColor(221, 221, 221);
    $pdf->Cell(90, 5, "Producto", 0, 0, 'C', 1);
    $pdf->Cell(40, 5, "Cantidad", 0, 0, 'C', 1);
    $pdf->Cell(30, 5, "P.Unitario", 0, 0, 'C', 1);
    $pdf->Cell(35, 5, "Total", 0, 0, 'C', 1);
    $pdf->Ln(5);
    $pdf->SetFont('Arial', '', 8);
    $total = 0;
    foreach ($venta as $item) {
        $subtotal = $item['cantidad'] * $item['precio'];
        $total += $subtotal;
        $pdf->Cell(90, 5, $item['descripcion'], 0, 0, 'L');
        $pdf->Cell(40, 5, $item['cantidad'], 0, 0, 'C');
        $pdf->Cell(30, 5, $item['precio'], 0, 0, 'R');
        $pdf->Cell(30, 5, number_format($item['cantidad'] * $item['precio'], 2), 0, 1, 'R');
        //$total += $item['cantidad'] * $item['precio'];
    }
    $pdf->Ln(2);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());

    // **📌 SUB-TOTAL**
    $subtotal = $total / 1.18;  // Calcular subtotal antes de IGV
    $igv = $total - $subtotal;
    $pdf->SetDrawColor(0, 0, 0);
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Ln(2);
    $texto5a = mb_convert_encoding("Op. No Gravada :", 'ISO-8859-1');
    $pdf->SetFont('Arial', 'B', 9); // Texto negrita
    $pdf->Cell(150);  // mover a la derecha
    $pdf->Cell(25, 5, $texto5a, 0, 0, 'L');
    $pdf->SetFont('Arial', 'B', 9); // Texto normal
    $pdf->Cell(20, 5, "S/ " . number_format($subtotal, 2, '.', ','), 0, 0, 'R');

    // **📌 IGV**
    $pdf->SetFont('Arial', 'B', 9); // Negrita
    $pdf->Ln(8);
    $texto5c = mb_convert_encoding("I.G.V.(18.00%)    :", 'ISO-8859-1');
    $pdf->SetFont('Arial', 'B', 9); // Texto negrita
    $pdf->Cell(150);  // mover a la derecha
    $pdf->Cell(25, 5, $texto5c, 0, 0, 'L');
    $pdf->SetFont('Arial', 'B', 9); // Texto normal
    $pdf->Cell(20, 5, "S/ " . number_format($igv, 2, '.', ','), 0, 0, 'R');

    // **📌 TOTAL**
    $pdf->SetFont('Arial', 'B', 9);
    $pdf->Ln(8);
    $pdf->Cell(125);  // mover a la derecha
    $pdf->Cell(50, 6, "                         IMPORTE TOTAL :", 0, 0, 'L');
    $pdf->Cell(20, 6, "S/ " . number_format($total, 2, '.', ','), 0, 0, 'R');
    $pdf->Ln(8);
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    //$pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto5g = mb_convert_encoding("SON :", 'ISO-8859-1');
    $total_venta = $total;
    $total_venta_letras = ' ' . numero_a_letras($total_venta);
    $pdf->SetFont('Arial', 'B', 9); // Texto negrita
    $pdf->Cell(40);
    $pdf->Write(4.5, $texto5g);
    $pdf->SetFont('Arial', '', 9); // Texto normal
    $pdf->Ln(0);
    $pdf->Cell(50);
    $pdf->Write(4.5, strtoupper($total_venta_letras));
    $pdf->Ln(6);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Ln(5);
    $pdf->Cell(70, 7, ''); // Avanzar línea para posicionar
    $texto6e = mb_convert_encoding("AGRADECEMOS SU PREFERENCIA VUELVA PRONTO!!!", 'ISO-8859-1');
    $texto6f = ' ';
    $pdf->SetFont('Arial', '', 7); // Texto negrita
    $pdf->Write(3, $texto6e);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(3, $texto6f);
    $pdf->Ln(2);
    //Agregar la imagen justo después del detalle
    $posY = $pdf->GetY() - 36; // Ajusta la posición en función del contenido
    $pdf->Image('img/barcode.png', 10, $posY, 28); //logo de la empresa,moverDerecha,moverAbajo,tamañoIMG

    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Ln(2);
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto1g = mb_convert_encoding("  Sirvase Abonar ala Cuenta de BOTICA VIRGEN DE GUADALUPE", 'ISO-8859-1');
    $texto2g = 'BCP                 SOLES 0000000000000';
    $pdf->SetFont('Arial', '', 7); // Texto negrita
    $pdf->Write(3, $texto1g);
    $pdf->Ln(4);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    //$pdf->Write(3, $texto2g);

    // Definir número de cuenta
    $numeroCuenta = 'BCP     SOLES   0000000000000';
    // Posición y tamaño del cuadro
    $x = 6;
    $y = 127;
    $width = 80;
    $height = 15;

    // Dibujar el rectángulo
    $pdf->Rect($x, $y, $width, $height, 'L');

    // Agregar número de cuenta dentro del cuadro
    $pdf->SetXY($x, $y + 4);
    $pdf->SetFont('helvetica', 'B', 10);
    $pdf->Cell($width, 10, $numeroCuenta, 0, 1, 'L');


    // **📌 Salida del PDF**
    $pdf->Output("I", $venta[0]['num_docpe'] . ".pdf");
}
if ($formato === "N") {
    $pdf = new FPDF('P', 'mm', array(80, 300)); // Ticket pequeño
    $pdf->AddPage();
    $pdf->SetMargins(5, 5, 5);
    $pdf->SetFont('Arial', 'B', 9);
    // **📌 CABECERA DEL DOCUMENTO**
    // Agregar logo
    $pdf->SetFont('Times', 'B', 9);
    //$pdf->Image('img/logo.jpeg', 5, 1, 40); //logo de la empresa,moverDerecha,moverAbajo,tamañoIMG
    $logoPath = $_SERVER['DOCUMENT_ROOT'] . '/Botica/views/ventas/img/Logo.png';
    // Verificar si existe
    if (file_exists($logoPath)) {
        $pdf->Image($logoPath, 5, 1, 40); // x, y, ancho
    } else {
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->SetTextColor(255, 0, 0);
        $pdf->Cell(0, 10, '⚠ Logo no encontrado: ' . $logoPath, 0, 1);
    }
    $pdf->SetFont('Arial', 'B', 8); //tipo fuente, negrita(B-I-U-BIU), tamañoTexto
    $pdf->ln(-15); // Movernos a la derecha
    $pdf->Cell(25); // Movernos a la derecha
    $pdf->SetTextColor(0, 0, 0); //color
    $pdf->Cell(20, 50, 'R.U.C. 20608279718', 0, 1, 'C', 0);
    $pdf->Ln(-22);
    /* RUC */
    $pdf->Cell(20);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(45, 1, mb_convert_encoding("BOTICA VIRGEN DE GUADALUPE", 'ISO-8859-1'), 0, 0, 'R', 0);
    $pdf->Ln(1);
    $pdf->Cell(20);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(1, 5, mb_convert_encoding("Telef.: (+51)960 879 247", 'ISO-8859-1'), 0, 0, '', 0);
    $pdf->Ln(5);
    /*DOCUMENTO*/
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, mb_convert_encoding("NOTA DE VENTA", 'ISO-8859-1'), 0, 0, 'C', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Ln(-1);
    $pdf->Cell(25);  // mover a la derecha
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(1, 15, mb_convert_encoding($venta[0]['num_docpe'], 'ISO-8859-1'), 0, 0, 'L', 0);
    $pdf->Ln(2);
    $pdf->SetDrawColor(0, 0, 0);
    $pdf->Ln(10);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->Ln(-5);
    // **📌 Información del Cliente**
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, ''); // Avanzar línea para posicionar
    $texto1a = mb_convert_encoding("Fecha de Emisión :", 'ISO-8859-1');
    $texto1b = ' ' . $venta[0]['fecha'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5, $texto1a);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5, $texto1b);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 5, ''); // Avanzar línea para posicionar
    $texto1c = mb_convert_encoding("Cliente : ", 'ISO-8859-1');
    $texto1d = ' ' . $venta[0]['cliente'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5, $texto1c);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5, $texto1d);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto1e = mb_convert_encoding("Dirección :", 'ISO-8859-1');
    $texto1f = ' ' . $venta[0]['direccion'];
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Write(5.5, $texto1e);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Write(5.5, $texto1f);
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto1g = mb_convert_encoding("Forma de Pago :", 'ISO-8859-1');
    $texto1h = ' ' . $venta[0]['metodo'];
    $pdf->SetFont('Arial', 'B', 8); // Texto negrita
    $pdf->Write(5.5, $texto1g);
    $pdf->SetFont('Arial', '', 8); // Texto normal
    $pdf->Write(5.5, $texto1h);
    $pdf->Ln(5);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    // **📌 TABLA DE DETALLES**
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(20, 5, "Cant - Precio", 0, 0, 'C');
    $pdf->Cell(40, 5, "Producto", 0, 0, 'C');
    $pdf->Cell(20, 5, "Total", 0, 0, 'L');
    $pdf->Ln(5);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->Ln(1);
    $pdf->SetFont('Arial', '', 8);
    $totalN = 0;
    foreach ($venta as $item) {
        $subtotal = $item['cantidad'] * $item['precio'];
        $totalN += $subtotal;
        $pdf->Cell(20, 5, $item['cantidad'] . ' x ' . $item['precio'], 0, 0, 'C');
        $pdf->MultiCell(50, 5, $item['descripcion'], 0, 'L');
        $pdf->Cell(80, 5, '                                                 SubTotal S/.  ' . number_format($item['cantidad'] * $item['precio'], 2), 0, 1, 'C');
        //$totalN += $item['cantidad'] * $item['precio'];
    }
    $pdf->Ln(2);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    // **📌 TOTAL**
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(50, 6, "TOTAL:", 0, 0, 'R');
    $pdf->Cell(20, 6, "S/ " . number_format($totalN, 2, '.', ','), 0, 0, 'R');
    $pdf->Ln(3);
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto5g = mb_convert_encoding("SON :", 'ISO-8859-1');
    $total_venta = $totalN;
    $total_venta_letras = ' ' . numero_a_letras($total_venta);
    $pdf->SetFont('Arial', 'B', 7); // Texto negrita
    $pdf->Write(4.5, $texto5g);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(4.5, strtoupper($total_venta_letras));
    $pdf->Ln(4);
    $pdf->Line(0, $pdf->GetY(), 209, $pdf->GetY());
    $pdf->SetFont('Arial', 'B', 8); // Negrita
    $pdf->Cell(0, 7, ''); // Avanzar línea para posicionar
    $texto6e = mb_convert_encoding("AGRADECEMOS SU PREFERENCIA VUELVA PRONTO!!!", 'ISO-8859-1');
    $texto6f = ' ';
    $pdf->SetFont('Arial', '', 7); // Texto negrita
    $pdf->Write(3, $texto6e);
    $pdf->SetFont('Arial', '', 7); // Texto normal
    $pdf->Write(3, $texto6f);
    //$posY = $pdf->GetY() + 5; // Ajusta la posición en función del contenido
    //$pdf->Image('img/barcode.png', 27, $posY, 28); //logo de la empresa,moverDerecha,moverAbajo,tamañoIMG
    // **📌 Salida del PDF**
    $pdf->Output("I", $venta[0]['num_docpe'] . ".pdf");
}

?>