<?php
// Conexión a MySQL
$conn = new mysqli('localhost', 'yoveraes_userdb', 't7@s5FxYn1GB', 'yoveraes_botica');
if ($conn->connect_error) {
  die("Error de Conexión: " . $conn->connect_error);
}

// Consulta de productos
$sql = "SELECT codproducto, descripcion, costos, precio, existencia FROM producto WHERE existencia > 0 ORDER BY existencia DESC";
$result = $conn->query($sql);

// Nombre del archivo
$fileName = "Lista_Productos_" . date("Y-m-d") . ".xls";

// Encabezados para forzar la descarga como Excel
header("Content-Type: application/vnd.ms-excel; charset=UTF-8");
header("Content-Disposition: attachment; filename=\"$fileName\"");
header("Pragma: no-cache");
header("Expires: 0");

// CSS para formato
echo '<html><head><meta charset="UTF-8">';
echo '<style>
                table { border-collapse: collapse; width: 100%; }
            th, td { border: 1px solid #dddddd; padding: 8px; text-align: center; font-size: 12px; }
            th { background-color: #4CAF50; color: white; font-weight: bold; }
            td { background-color: #f9f9f9; }
            tr:nth-child(even) { background-color: #f2f2f2; }
            tr:hover { background-color: #ddd; }
            .total { font-weight: bold; background-color: #e6f7ff; }
            .total td { text-align: right; }
            .total th { background-color:rgb(76,175,80); font-weight: bold; }
            .currency { mso-number-format:"\\S/ \\#,##0.00"; }
          </style>';
echo '</head><body>';

// Título
echo "<h2 style='text-align: center; color: #4CAF50;'>Reporte de Productos - Inventarios</h2>";

// Iniciar tabla
echo "<table>";
echo "<tr>
        <th>Item</th>
        <th>Código</th>
        <th>Nombre Producto</th>
        <th>Precio Costo</th>
        <th>Total Costo</th>
        <th>Precio P.V.P.</th>
        <th>Total P.V.P.</th>
        <th>STOCK</th>
      </tr>";

// Llenar tabla con datos
// Variables para acumular totales
$total_general_costo = 0;
$total_general_precio = 0;
$correlativo = 1;
while ($row = $result->fetch_assoc()) {

  // Calcular total por costo y por precio
  $total_costo = $row['costos'] * $row['existencia'];
  $total_precio = $row['precio'] * $row['existencia'];

  // Acumular totales generales
  $total_general_costo += $total_costo;
  $total_general_precio += $total_precio;

  echo "<tr>
            <td style='width:50px;text-align:center;'>{$correlativo}</td>
            <td style='width:50px;text-align:center;'>{$row['codproducto']}</td>
            <td style='width:600px;text-align:left;'>{$row['descripcion']}</td>
            <td class='currency; width:50px; text-align:right;'>{$row['costos']}</td>
            <td class='currency' style='width:90px;text-align:right;'>{$total_costo}</td>
            <td class='currency; width:50pxtext-align:right;'>{$row['precio']}</td>
            <td class='currency' style='width:90px;text-align:right;'>{$total_precio}</td>
            <td>{$row['existencia']}</td>
          </tr>";
  $correlativo++;
}
// Fila de totales al final
echo "<tr style='font-weight:bold; background-color:#e6f7ff;'>
        <td colspan='4' style='text-align:right;'>TOTALES:</td>
        <td class='currency' style='text-align:right;'>{$total_general_costo}</td>
        <td style='text-align:right;'>        </td>
        <td class='currency' style='text-align:right;'>{$total_general_precio}</td>
      </tr>";
echo "</table>";
echo '</body></html>';
exit;
?>