<?php
session_start();
$conn = new mysqli('localhost', 'yoveraes_userdb', 't7@s5FxYn1GB', 'yoveraes_botica');
if ($conn->connect_error) {
  echo 'Error de Conexión ' . $conn->connect_error;
  exit;
}
if (isset($_GET['fecha'])) {
  $fecha = $_GET['fecha'];

  $stmt = $conn->prepare("SELECT fecha, num_docpe, total, metodo, hora_vtap, cliente FROM ventas WHERE fecha = ? and correo='$_SESSION[correo]'");
  $stmt->bind_param("s", $fecha);
  $stmt->execute();
  $result = $stmt->get_result();
  $correo = $_SESSION['correo'];
  // Nombre del archivo
  $fileName = "Caja_Diaria" . $fecha . ".xls";
  // Encabezados para descargar el archivo en Excel
  header("Content-Type: application/vnd.ms-excel; charset=UTF-8");
  header("Content-Disposition: attachment; filename=\"$fileName\"");
  header("Pragma: no-cache");
  header("Expires: 0");
  // Estilos CSS para el archivo Excel
  echo '<html><head><meta charset="UTF-8">';
  echo '<style>
            table { border-collapse: collapse; width: 100%; }
            th, td { border: 1px solid #dddddd; padding: 8px; text-align: center; font-size: 12px; }
            th { background-color: #4CAF50; color: white; font-weight: bold; }
            td { background-color: #f9f9f9; }
            tr:nth-child(even) { background-color: #f2f2f2; }
            tr:hover { background-color: #ddd; }
            .total { font-weight: bold; background-color: #e6f7ff; }
            .total td { text-align: right; }
            .total th { background-color:rgb(76,175,80); font-weight: bold; }
            .currency { mso-number-format:"\\S/ \\#,##0.00"; }
          </style>';
  echo '</head><body>';
  // Título
  echo "<h2 style='text-align: center; color: #4CAF50;'>Reporte Caja Diaria Botica Virgen de Guadalupe - Fecha: $fecha</h2>";
  echo "<h1 style='text-align: center; color: #3e64d3;'>Usuario : $correo</h1>";
  // Iniciar la tabla

  echo "<table>";
  echo "<tr>
            <th>Item.</th>
            <th>Fecha Venta</th>
            <th>Hora Venta</th>
            <th>Documento</th>
            <th>Cliente</th>
            <th>Forma Pago</th>
            <th>Total</th>
          </tr>";

  // Llenar datos
  $total = 0;
  $correlativo = 1; // Iniciar el número correlativo en 1
  while ($venta = $result->fetch_assoc()) {
    $total += floatval($venta['total']);
    echo "<tr>
                <td style='width:40px;text-align:center;'>$correlativo</td>
                <td style='width:100px;text-align:center;'>{$venta['fecha']}</td>
                <td style='width:100px;text-align:center;'>{$venta['hora_vtap']}</td>
                <td style='width:100px;text-align:center;'>{$venta['num_docpe']}</td>
                <td style='width:220px;text-align:left;'>{$venta['cliente']}</td>
                <td style='width:100px;text-align:right;'>{$venta['metodo']}</td>
                <td class='currency' style='width:120px;text-align:right;'>{$venta['total']}</td>
              </tr>";
    $correlativo++; // Incrementar el correlativo en cada iteración
  }
  // Agregar total al final
  echo "<tr class='total'>
            <th colspan='6' style='font-size:16px;text-align:right;'>TOTALES :&nbsp;&nbsp;</th>
            <td class='currency'style='font-size:16px;text-align:right;'>{$total}</td>
          </tr>";
  echo "</table>";
  echo '</body></html>';
  exit;
}
?>