<script>

    function editarPedido(id) {
        $.ajax({
            url: `/Botica/views/ventas/obtener_pedido.php`,
            type: 'POST',
            data: { id_venta: id },
            dataType: 'json',
            success: function (response) {
                $('#id_venta').val(response.venta.id_venta);
                $('#cliente').val(response.venta.cliente);
                $('#total').val(response.venta.total);
                $('#metodo').val(response.venta.metodo);

                let detalleHTML = '';
                response.detalle.forEach(function (item) {
                    detalleHTML += `
                <tr>
                    <td><input type="hidden" name="id_producto[]" value="${item.id_producto}">
                        ${item.producto}
                    </td>
                    <td><input type="number" name="cantidad[]" value="${item.cantidad}" class="form-control cantidad"></td>
                    <td><input type="number" name="precio[]" value="${item.precio}" class="form-control precio"></td>
                    <td>${item.presentacion}</td>
                </tr>`;
                });
                $('#detalle_venta').html(detalleHTML);

                // Evento para actualizar el total al cambiar cantidad o precio
                $('.cantidad, .precio').on('input', actualizarTotal);

                $('#modalEditarPedido').modal('show');
            }
        });
    }

    function actualizarTotal() {
        let total = 0;
        $('#detalle_venta tr').each(function () {
            let cantidad = parseFloat($(this).find('.cantidad').val()) || 0;
            let precio = parseFloat($(this).find('.precio').val()) || 0;
            total += cantidad * precio;
        });
        $('#total').val(total.toFixed(2));
    }


</script>