<?php
session_start();
$servername = "localhost";
$username = "yoveraes_userdb";
$password = "t7@s5FxYn1GB";
$dbname = "yoveraes_botica";

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Error de conexión: " . $e->getMessage());
}

// Función para validar usuario
function validarUsuario($usuario, $password, $conn)
{
    try {
        $stmt = $conn->prepare("SELECT correo, clave, nombre FROM usuario WHERE correo = ?");
        $stmt->execute([$usuario]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user && password_verify($password, $user['clave'])) {
            return $user;
        }
        return false;
    } catch (PDOException $e) {
        return false;
    }
}

// Función para obtener lista de usuarios
function obtenerUsuarios($conn)
{
    try {
        $stmt = $conn->query("SELECT correo, nombre FROM usuario ORDER BY nombre");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        return [];
    }
}

function mostrarMensaje($tipo, $mensaje)
{
    $clase = $tipo == 'exito' ? 'exito' : 'error';
    return "<div class='mensaje $clase'>$mensaje</div>";
}

// Insertar usuarios de ejemplo (ejecutar una sola vez)
function insertarUsuariosEjemplo($conn)
{
    $usuarios = [
        ['admin', 'Admin123', 'Administrador Principal'],
        ['caja', 'Caja123', 'Usuario de Caja'],
        ['contabilidad', 'Conta123', 'Departamento Contabilidad']
    ];

    foreach ($usuarios as $user) {
        // Verificar si el usuario ya existe
        $stmt = $conn->prepare("SELECT COUNT(*) FROM usuario WHERE correo = ?");
        $stmt->execute([$user[0]]);
        $existe = $stmt->fetchColumn();

        if (!$existe) {
            $hash = password_hash($user[1], PASSWORD_DEFAULT);
            $stmt = $conn->prepare("INSERT INTO usuario (correo, clave, nombre) VALUES (?, ?, ?)");
            $stmt->execute([$user[0], $hash, $user[2]]);
        }
    }
}

// Ejecutar una vez para crear usuarios de ejemplo
// insertarUsuariosEjemplo($conn);
?>