$(document).ready(function () {
    // Buscar productos
    $('#buscar').on('input', function () {
        let query = $(this).val();
        $.ajax({
            url: '/Botica/views/ventas/buscar_producto.php',
            method: 'GET',
            data: { query },
            success: function (data) {
                $('#tabla-productos tbody').html(data);
            }
        });
    });

    // Añadir producto al carrito
    $(document).on('click', '.agregar-carrito', function () {
        let id = $(this).data('id');
        let nombre = $(this).data('nombre');
        let presentacion = $(this).data('presentacion');
        let precio = $(this).data('precio');
        let stock = $(this).data('stock');

        // Añadir al carrito si hay stock
        if (stock > 0) {
            let fila = `
                <tr data-id="${id}">
                    <td style="cursor:pointer;color:rgb(0,0,0);text-align:left;">${nombre}</td>
                    <td>${precio}</td>
                    <td><input type="number" class="cantidad" value="1" min="1" max="${stock}"></td>
                    <td class="subtotal">${precio}</td>
                    <td style="cursor:pointer;color:rgb(0,0,0);text-align:center;">${presentacion}</td>
                    <td><button class="eliminar"><i class="fas fa-trash-alt"></i> Eliminar</button></td>
                </tr>`;
            $('#tabla-carrito tbody').append(fila);
            actualizarTotal();
        } else {
            alert('Sin stock disponible');
        }
    });

    // Actualizar subtotal y total
    $(document).on('input', '.cantidad', function () {
        let cantidad = $(this).val();
        let precio = $(this).closest('tr').find('td:nth-child(2)').text();
        let subtotal = (cantidad * precio).toFixed(2);
        $(this).closest('tr').find('.subtotal').text(subtotal);
        actualizarTotal();
    });

    // Eliminar producto del carrito
    $(document).on('click', '.eliminar', function () {
        $(this).closest('tr').remove();
        actualizarTotal();
    });

    // Guardar venta
    $('#guardar-venta').on('click', function () {
        let cliente = $('#nombre-cliente').val();
        let metodo = $('#metodo').val();
        let productos = [];

        $('#tabla-carrito tbody tr').each(function () {
            let id = $(this).data('id');
            let cantidad = $(this).find('.cantidad').val();
            let precio = $(this).find('td:nth-child(2)').text();
            let subtotal = $(this).find('.subtotal').text();
            productos.push({ id, cantidad, precio, subtotal });
        });

        if (productos.length > 0) {
            $.ajax({
                url: '/Botica/views/ventas/guardar_venta.php',
                method: 'POST',
                data: { cliente, metodo, productos },
                success: function (data) {
                    alert(data);
                    location.reload();
                },
                error: function (xhr, status, error) {
                    console.error('Error:', error);
                }
            });
        } else {
            alert('No hay productos en el carrito');
        }
    });

    function actualizarTotal() {
        let total = 0;
        $('#tabla-carrito .subtotal').each(function () {
            total += parseFloat($(this).text());
        });
        $('#total-venta').text(total.toFixed(2));
    }
});
