<?php
require 'conexiom.php';

$id_venta = $_POST['id_venta'];
$cliente = $_POST['cliente'];
$metodo = $_POST['metodo'];
$id_producto = $_POST['id_producto'];
$cantidad = $_POST['cantidad'];
$precio = $_POST['precio'];
// Calcular el total sumando (cantidad * precio) de cada producto
$total = 0;
for ($i = 0; $i < count($id_producto); $i++) {
    $subtotal = $cantidad[$i] * $precio[$i];
    $total += $subtotal;
}
$conn->begin_transaction();
try {
    // Actualizar la tabla ventas con el nuevo total
    $sql = "UPDATE ventas SET cliente = ?, total = ?, metodo = ? WHERE id_venta = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sdsi", $cliente, $total, $metodo, $id_venta);
    $stmt->execute();
    // Actualizar cada detalle de la venta
    for ($i = 0; $i < count($id_producto); $i++) {
        $sql_detalle = "UPDATE detalle_ventas SET cantidad = ?, precio = ? WHERE id_venta = ? AND id_producto = ?";
        $stmt_detalle = $conn->prepare($sql_detalle);
        $stmt_detalle->bind_param("ddii", $cantidad[$i], $precio[$i], $id_venta, $id_producto[$i]);
        $stmt_detalle->execute();
    }
    $conn->commit();
    echo json_encode(["success" => true, "message" => "Pedido actualizado correctamente"]);
} catch (Exception $e) {
    $conn->rollback();
    echo json_encode(["success" => false, "message" => "Error al actualizar pedido"]);
}
?>