<?php
session_start();
require 'conexionn.php';
$metodo_pago = isset($_POST['tipo_pago']) ? $_POST['tipo_pago'] : '';
$id = isset($_POST['id']) ? (int) $_POST['id'] : 0;
$num_doc = isset($_POST['numcpe']) ? $_POST['numcpe'] : '';
date_default_timezone_set('America/Lima');
$hora = date('H:i:s'); // Hora actual
$tipo_doc = isset($_POST['formato']) ? $_POST['formato'] : '';
$sql = "UPDATE ventas SET metodo = ?, tipo_doc = ?, num_docpe=?, hora_vtab = ?  WHERE id = '$id'";
$stmt = $conn->prepare($sql);
if ($stmt) {
    $stmt->bind_param("ssss", $metodo_pago, $tipo_doc, $num_doc, $hora);
    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            echo json_encode(["status" => "success", "message" => "✅ Pedido actualizado correctamente"]);
        } else {
            echo json_encode(["status" => "warning", "message" => "⚠️ No se actualizó ningún registro."]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "❌ Error al actualizar: " . $stmt->error]);
    }
    $stmt->close();
} else {
    echo json_encode(["status" => "error", "message" => "❌ Error en la consulta SQL: " . $conn->error]);
}

// 2️⃣ **Actualizar numeración del documento**
$sql4 = "";
if ($tipo_doc == "B") {
    $sql4 = "UPDATE emis_doc SET Emis_doc_Num = Emis_doc_Num + 1 WHERE TpDoc_emis_doc = '03' AND correo = ?";
} elseif ($tipo_doc == "F") {
    $sql4 = "UPDATE emis_doc SET Emis_doc_Num = Emis_doc_Num + 1 WHERE TpDoc_emis_doc = '01' AND correo = ?";
} elseif ($tipo_doc == "N") {
    $sql4 = "UPDATE emis_doc SET Emis_doc_Num = Emis_doc_Num + 1 WHERE TpDoc_emis_doc = '99' AND correo = ?";
}
if (!empty($sql4)) {
    if ($stmt4 = $conn->prepare($sql4)) {
        $stmt4->bind_param('s', $_SESSION['correo']);
        if (!$stmt4->execute()) {
            echo json_encode(["status" => "error", "message" => "Error al actualizar numeración de documento"]);
            exit;
        }
        $stmt4->close();
    }
}
$conn->close();
?>