<?php
require('fpdf/fpdf.php');

// Conexión a MySQL
$conn = new mysqli('localhost', 'root', '', 'yoveraes_botica');
if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}

// Consulta
$sql = "SELECT codproducto , descripcion, costos, precio, existencia, codigo, presentacion FROM producto WHERE existencia > 0 ORDER BY existencia DESC";
$result = $conn->query($sql);

// Crear PDF en horizontal
$pdf = new FPDF('L', 'mm', 'A4');
$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 10);

// Encabezados
$header = ['#', 'Barcod.', 'Nombre Producto', 'Present.', 'P.Costo', 'Total Costo', 'P.V.P.', 'Total PVP', 'STOCK'];
$w = [10, 10, 90, 20, 20, 25, 20, 25, 25]; // anchos ajustados

for ($i = 0; $i < count($header); $i++) {
    $pdf->Cell($w[$i], 7, mb_convert_encoding($header[$i], 'ISO-8859-1'), 1, 0, 'C');
}
$pdf->Ln();

// Contenido
$pdf->SetFont('Arial', '', 8);
$correlativo = 1;
while ($row = $result->fetch_assoc()) {
    $total = $row['existencia'] * $row['costos']; // multiplicar existencia × costo

    $pdf->Cell($w[0], 8, $correlativo++, 1, 0, 'C');
    $pdf->Cell($w[1], 8, $row['codproducto'], 1);
    $pdf->Cell($w[2], 8, mb_convert_encoding($row['descripcion'], 'ISO-8859-1'), 1);
    $pdf->Cell($w[3], 8, mb_convert_encoding($row['presentacion'], 'ISO-8859-1'), 1);
    $pdf->Cell($w[4], 8, mb_convert_encoding($row['codigo'], 'ISO-8859-1'), 1);
    $pdf->Cell($w[5], 8, $row['existencia'], 1, 0, 'C');
    $pdf->Cell($w[6], 8, number_format($row['costos'], 2), 1, 0, 'R');
    $pdf->Cell($w[7], 8, number_format($row['precio'], 2), 1, 0, 'R');
    $pdf->Cell($w[8], 8, number_format($total, 2), 1, 0, 'R');
    $pdf->Ln();
}

$pdf->Output();
?>