$(document).ready(function () {
	$("#sales-form").submit(function (e) {
		e.preventDefault(); // Evita la recarga de la página
		let formData = $(this).serialize(); // Captura los datos del formulario
		$.ajax({
			url: '/Botica/views/compras/guardar_venta.php',
			type: 'POST',
			data: formData,
			dataType: 'json',
			success: function (response) {
				console.log("Respuesta del servidor:", response); // Para depuración
				if (response.success) {
					// Abrir el PDF en nueva ventana
					let url = '/Botica/views/compras/imprimir_liquidacion.php?idcompra=' + response.idcompra;
					window.open(url, '_blank');
					alert("Compra registrada con éxito. ID: " + response.idcompra);
				} else {
					alert("Error al registrar la compra.");
				}
			},
			error: function (xhr, status, error) {
				console.error("Error AJAX:", error);
				alert("Hubo un error al registrar la compra.");
			}
		});
	});
});