<?php
require 'conexionn.php';

// Obtener el tipo de comprobante del formulario
$tipo = $_POST['tipo_cpe'];

// Validar el tipo de comprobante
if ($tipo !== 'B' && $tipo !== 'F' && $tipo !== 'N' && $tipo !== 'G' && $tipo !== 'L') {
  die("Tipo de comprobante no válido.");
}

// Consulta para obtener el número correlativo
$sql = "SELECT MAX(Emis_doc_Num) as ultimo_numero FROM emis_doc WHERE Emis_doc_Vra = ? and correo='$_SESSION[correo]'";
$stmt = $mysqli->prepare($sql);
$stmt->bind_param("s", $tipo);
$stmt->execute();
$result = $stmt->get_result();

$sql1 = "SELECT Emis_doc_Serie as serie_numero FROM emis_doc WHERE Emis_doc_Vra = ? and correo='$_SESSION[correo]'";
$stmt1 = $mysqli->prepare($sql1);
$stmt1->bind_param("s", $tipo);
$stmt1->execute();
$result1 = $stmt1->get_result();

$sql2 = "SELECT Emis_doc_Serie as serie_numero FROM emis_doc WHERE Emis_doc_Vra = ? and correo='$_SESSION[correo]'";
$stmt2 = $mysqli->prepare($sql2);
$stmt2->bind_param("s", $tipo);
$stmt2->execute();
$result2 = $stmt2->get_result();

// Verificar si la consulta fue exitosa
if ($result->num_rows > 0) {
  $row = $result->fetch_assoc();
  $ultimo_numero = $row['ultimo_numero'];
  $nuevo_numero = $ultimo_numero ? $ultimo_numero + 1 : 1;
  $row1 = $result1->fetch_assoc();
  $serie_numero = $row1['serie_numero'];

  echo htmlspecialchars($tipo) . str_pad($serie_numero, 3, '0', STR_PAD_LEFT) . "-" . str_pad($nuevo_numero, 6, '0', STR_PAD_LEFT);
} else {
  echo "No se encontraron comprobantes para el tipo seleccionado.";
}