<!-- index.php - Reporte de pedidos pendientes -->
<?php
require('conexion.php');
$sql = "SELECT id, fecha, proveedor, total, num_doc,hora_vtap,doc_ident, metodo FROM compras";
$result = $conn->query($sql);
$contador = 1;
//$fecha_inicio = $_GET['fecha_inicio'] ?? date('Y-m-01');
//$fecha_fin = $_GET['fecha_fin'] ?? date('Y-m-d'); // Fecha actual
// Obtener primer y último día del mes anterior
$primer_dia_mes_anterior = date('Y-m-01', strtotime('first day of last month'));
$ultimo_dia_mes_anterior = date('Y-m-t', strtotime('last day of last month'));
// Fechas por defecto: mes anterior o valores enviados por GET
$fecha_inicio = $_GET['fecha_inicio'] ?? $primer_dia_mes_anterior;
$fecha_fin = $_GET['fecha_fin'] ?? $ultimo_dia_mes_anterior;
// Calcular totales
$total_subtotal = 0;
$total_igv = 0;
$total_total = 0;
?>
<!DOCTYPE html>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Compras Proveedor</title>
    <script src="/Botica/views/compras/js/jquery.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css"
        integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
    <script language="javascript" src="/Botica/views/compras/js/jquery-3.1.1.min.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script language="javascript"></script>
    <style>
        /* Estilos personalizados para el botón */
        .boton-personalizado {
            background-color: #4CAF50;
            /* Verde */
            border: none;
            color: white;
            padding: 15px 32px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 18px;
            margin: 4px 2px;
            cursor: pointer;
            border-radius: 12px;
        }

        .boton-personalizado:hover {
            background-color: #45a049;
            /* Verde más oscuro */
        }
    </style>
    <style>
        /* Estilos básicos */
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }

        .container {
            max-width: 1000px;
            margin: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            padding: 10px;
            border: 1px solid #ccc;
            text-align: center;
        }

        button {
            padding: 5px 10px;
            color: #fff;
            background: #e74c3c;
            border: none;
            cursor: pointer;
        }

        button:hover {
            background: #c0392b;
        }
    </style>
    <style>
        /* Estilo para reducir la fuente */
        .tabla-pequena {
            font-size: 14px;
            /* Ajusta el tamaño de la fuente */
            border-collapse: collapse;
            width: 100%;
        }

        .tabla-pequena th,
        .tabla-pequena td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        .tabla-pequena th {
            background-color: #002315;
            text-align: left;
        }
    </style>
    <script>
        // Función para sumar los valores de la columna de montos
        function sumarMontos() {
            let total = 0;
            let montos = document.querySelectorAll('.total'); // Seleccionamos todos los elementos con la clase 'monto'
            montos.forEach(function (element) {
                total += parseFloat(element.innerText) || 0;  // Sumamos el contenido de cada elemento
            });
            // Mostrar el total en el campo de texto con id "totalMonto"
            document.getElementById('totalMonto').value = total.toFixed(2);
        }
    </script>
    <script>
        function obtenerNumeroCorrelativo() {
            var tipo = document.getElementById("tipo_cpe").value;
            var xhr = new XMLHttpRequest();
            xhr.open("POST", "/Botica/views/compras/mostrar_comprobantes.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.onload = function () {
                if (xhr.status === 200) {
                    // Actualizar el valor del campo de texto con el resultado recibido
                    document.getElementById("numero_correlativo").value = xhr.responseText;
                } else {
                    document.getElementById("numero_correlativo").value = "Error al obtener el número.";
                }
            };
            xhr.send("tipo_cpe=" + encodeURIComponent(tipo));
        }
    </script>
    <script>
        // Cambiar color al enfocar
        function changeColor(element, color) {
            element.style.backgroundColor = color;
        }

        // Restaurar color al salir
        function resetColor(element) {
            element.style.backgroundColor = '';
        }
    </script>
</head>

<body onload="buscarVentas()">
    <h2 class="subtitle"><i class="fas fa-box-open"></i> &nbsp;Reporte Total de Compras | Compras Mensuales <i
            class="fas fa-box-open"></i></h2>
    <form id="filtro-form">
        <label>Desde: <input onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)" type="date"
                id="fecha_inicio" value="<?= $fecha_inicio ?>"></label>
        <label>Hasta: <input type="date" id="fecha_fin" value="<?= $fecha_fin ?>"></label>
        <label>Tipo de documento:
            <select id="tipo_doc" onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)">
                <option value="">Todos</option>
                <option value="B">Boleta</option>
                <option value="F">Factura</option>
                <option value="L">Liquidacion Compra</option>
            </select>
        </label>
        <label style="display:none">Número de Documento: <input onfocus="changeColor(this, '#f7f201')"
                onblur="resetColor(this)" type="text" id="num_doc"></label>
        <button type="button" class="btn btn-success" onclick="buscarVentas()"><i
                class="fas fa-search"></i>&nbsp;Buscar</button>
    </form>
    <div class="exportaciones">
        <a href="/Botica/views/compras/export_excel.php?mes=<?= $mes ?>&anio=<?= $anio ?>"
            style="font-weight: bold; color: #60605e;">📥 Exportar a Excel</a> |
        <a href="/Botica/views/compras/export_txt.php?mes=<?= $mes ?>&anio=<?= $anio ?>"
            style="font-weight: bold; color: #ff5722;">📥 Exportar TXT Para SIRE</a>
    </div>
    <table border="1" class="table table-striped table-hover tabla-pequena" style="width: 100%;">
        <thead class="table-dark table-bordered">
            <tr>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;font-size:16px;font-weight-bold;">It.
                </th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;font-size:16px;font-weight-bold;">
                    Fecha</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;font-size:16px;font-weight-bold;">
                    Documento</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;font-size:16px;font-weight-bold;">
                    RUC/DNI</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;font-size:16px;font-weight-bold;">
                    Razón social</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;font-size:16px;font-weight-bold;">
                    Forma de Pago</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;font-size:16px;font-weight-bold;">
                    Valor Compra</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;font-size:16px;font-weight-bold;">
                    I.G.V.</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;font-size:16px;font-weight-bold;">
                    Importe Total</th>
                <th style="cursor:pointer;color:rgb(255,255,32);text-align:center;font-size:16px;font-weight-bold;">
                    Acción</th>
            </tr>
        </thead>
        <tbody id="ventas-body">
            <!-- Aquí se mostrarán los datos -->
        </tbody>
    </table>

    <script>
        function buscarVentas() {
            let fecha_inicio = $("#fecha_inicio").val();
            let fecha_fin = $("#fecha_fin").val();
            let tipo_doc = $("#tipo_doc").val();
            let num_doc = $("#num_doc").val();

            $.ajax({
                url: "/Botica/views/compras/reporte_ventas.php",
                type: "GET",
                data: { fecha_inicio, fecha_fin, tipo_doc, num_doc },
                success: function (response) {
                    $("#ventas-body").html(response);
                }
            });
        }
        function reimprimirDocumento(id, tipo) {
            window.open("/Botica/views/compras/reimprimir.php?id=" + id + "&tipo=" + tipo, "_blank");
        }

        function eliminarVenta(id, numDoc) {
            if (confirm("¿Estás seguro de eliminar la compra con número " + numDoc + "?")) {
                $.ajax({
                    url: '/Botica/views/compras/eliminar_compra.php',
                    type: 'POST',
                    data: { id: id },
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            alert("Compra eliminada y stock actualizado correctamente");
                            location.reload(); // Recargar la página para actualizar la tabla
                        } else {
                            alert("Error: " + response.error);
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error("Error AJAX:", error);
                        alert("No se pudo eliminar la compra.");
                    }
                });
            }
        }
    </script>


</body>

</html>