<?php
require_once('fpdf/fpdf.php');
session_start(); // NECESARIO para usar $_SESSION
$conn = new mysqli('localhost', 'yoveraes_userdb', 't7@s5FxYn1GB', 'yoveraes_botica');
if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}
$conn->set_charset("utf8");
// Activar transacción
$conn->begin_transaction();
try {
    // Recibir datos
    $cliente = $_POST['cliente'];
    $metodo = $_POST['metodo'];
    $tipoCpe = $_POST['tipoCpe'];
    $numdocumento = $tipoCpe . $_POST['numdocumento'];
    $fecha = $_POST['FechaSunat'];
    $docident = $_POST['docident'];
    $total = $_POST['total'];
    $direccion = $_POST['direcc'];
    $productos = $_POST['productos']; // Array de productos

    $id_user = $conn->real_escape_string($_SESSION['idusuario']);
    $correo = $conn->real_escape_string($_SESSION['correo']);
    date_default_timezone_set('America/Lima');
    $hora_venta = date('H:i:s');

    if (empty($productos)) {
        throw new Exception("No se recibieron productos.");
    }

    // Insertar en tabla compras
    $sql_venta = "INSERT INTO compras (proveedor, metodo, num_doc, tipo_doc, id_usuario, correo, fecha, doc_ident, total, direc_prov, hora_vtap)
                  VALUES ('$cliente', '$metodo', '$numdocumento', '$tipoCpe', '$id_user', '$correo', '$fecha', '$docident', '$total', '$direccion', '$hora_venta')";

    if (!$conn->query($sql_venta)) {
        throw new Exception("Error al insertar compra: " . $conn->error);
    }

    $idventas = $conn->insert_id;

    // Insertar detalles
    foreach ($productos as $producto) {
        $id_producto = $producto['id'];
        $cantidad = $producto['cantidad'];
        $precio = floatval($producto['precio']);
        $presentacion = isset($producto['presentacion']) ? $producto['presentacion'] : '';

        // Verificar stock actual
        $result = $conn->query("SELECT existencia FROM producto WHERE codproducto = $id_producto");
        if (!$result || $result->num_rows == 0) {
            throw new Exception("Producto no encontrado con ID: $id_producto");
        }

        $prod = $result->fetch_assoc();

        if ($prod['existencia'] >= 0) {
            $sql_det = "INSERT INTO detalle_compras (id_compra, id_producto, precio, cantidad, presentacion, FechaComp)
                        VALUES ($idventas, $id_producto, $precio, $cantidad, '$presentacion', '$fecha')";

            if (!$conn->query($sql_det)) {
                throw new Exception("Error al insertar detalle: " . $conn->error);
            }

            $conn->query("UPDATE producto SET existencia = existencia + $cantidad WHERE codproducto = $id_producto");
        } else {
            throw new Exception("Stock insuficiente para el producto $id_producto");
        }
    }

    // Actualizar numeración si corresponde
    if (in_array($tipoCpe, ["L", "F", "B", "O"])) {
        $sql4 = "UPDATE emis_doc SET Emis_doc_Num = Emis_doc_Num + 1 
                 WHERE TpDoc_emis_doc = '97' AND correo = '$correo'";
        $stmt = $conn->prepare($sql4);
        if (!$stmt->execute()) {
            throw new Exception("Error al actualizar numeración: " . $stmt->error);
        }
    }

    // Confirmar todo
    $conn->commit();

    // Respuesta exitosa
    $response = [
        "status" => "success",
        "mensaje" => "Compra registrada correctamente",
        "idcompra" => $idventas,
        "total" => $total
    ];
    echo json_encode($response);

} catch (Exception $e) {
    $conn->rollback();
    echo json_encode(["status" => "error", "mensaje" => $e->getMessage()]);
}
?>