<?php
include("conexion.php");
/// Obtener primer y último día del mes anterior
$primer_dia_mes_anterior = date('Y-m-01', strtotime('first day of last month'));
$ultimo_dia_mes_anterior = date('Y-m-t', strtotime('last day of last month'));
// Fechas recibidas por GET o por defecto mes anterior
$fecha_inicio = $_GET['fecha_inicio'] ?? $primer_dia_mes_anterior;
$fecha_fin = $_GET['fecha_fin'] ?? $ultimo_dia_mes_anterior;
$tipo_doc = $_GET['tipo_doc'] ?? '';
// Extraemos el año y el mes de la fecha (de la venta o de la fecha que se esté procesando)
$anual = date('Y', strtotime($fecha_inicio));  // Año (ej. "2025")
$mensual = date('m', strtotime($fecha_inicio));  // Mes (ej. "03")
// Consulta SQL
$sql = "SELECT * FROM compras WHERE tipo_doc  IN ('B', 'F') AND fecha BETWEEN ? AND ?";
$params = [$fecha_inicio, $fecha_fin];
if ($tipo_doc === 'B') {
    $sql .= " AND tipo_doc = 'B'";
} elseif ($tipo_doc === 'F') {
    $sql .= " AND tipo_doc = 'F'";
}
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $fecha_inicio, $fecha_fin);
$stmt->execute();
$resultado = $stmt->get_result();
// Encabezado del archivo TXT
header("Content-Type: text/plain");
header("Content-Disposition: attachment; filename=LE20608279718{$anual}{$mensual}00080400021112.txt");
$contador = 1;
while ($row = $resultado->fetch_assoc()) {
    $total = $row['total'];
    $subtotal = $total / 1.18;
    $igv = $total - $subtotal;
    $codigo_tipo_doc = ($row['tipo_doc'] == 'B') ? '03' : (($row['tipo_doc'] == 'F') ? '01' : '00');
    echo '20608279718' . "|" .
        'YOVERA CORP EIRL' . "|" .
        $yyyymm = date('Ym', strtotime($row['fecha'])) . "|" .
        '' . "|" .
        date('d/m/Y', strtotime($row['fecha'])) . "|" .
        date('d/m/Y', strtotime($row['fecha'])) . "|" .
        (($row['tipo_doc'] == 'B') ? '03' : (($row['tipo_doc'] == 'F') ? '01' : '00')) . "|" .
        substr($row['num_doc'], 0, 4) . "|" .
        '' . "|" .
        substr($row['num_doc'], 5, 6) . "|" .
        '' . "|" .
        (strlen($row['doc_ident']) == 11 ? '6' : '1') . "|" .
        (strlen($row['doc_ident']) < 8 ? '00000000' : $row['doc_ident']) . "|" .
            //$row['doc_ident'] . "|" .
            //$row['proveedor'] . "|" .
        (strlen($row['proveedor']) < 8 ? 'PROVEEDORES VARIOS' : $row['proveedor']) . "|" .
        number_format($subtotal, 2) . "|" .
        number_format($igv, 2) . "|" .
        '0.00' . "|" .
        '0.00' . "|" .
        '0.00' . "|" .
        '0.00' . "|" .
        '0.00' . "|" .
        '0.00' . "|" .
        '0.00' . "|" .
        '0.00' . "|" .
        number_format($total, 2) . "|" .
        'PEN' . "|" .
        '' . "|" .
        '' . "|" .
        '' . "|" .
        '' . "|" .
        '' . "|" .
        '' . "|" .
        '' . "|" .
        '' . "|" .
        '' . "|" .
        '' . "|" .
        '' . "|" .
        '' . "\n";
    $contador++;
}
exit;
?>