<?php
include("conexion.php");
// Obtener primer y último día del mes anterior
$fecha_inicio = date('Y-m-01', strtotime('first day of last month'));
$fecha_fin = date('Y-m-t', strtotime('last day of last month'));
$mes = date('m', strtotime($fecha_inicio));
$anio = date('Y', strtotime($fecha_inicio));
$tipo_doc = $_GET['tipo_doc'] ?? '';
// Consulta SQL
$sql = "SELECT * FROM compras WHERE tipo_doc  IN ('B', 'F') AND fecha BETWEEN ? AND ?";
$params = [$fecha_inicio, $fecha_fin];
if ($tipo_doc === 'B') {
  $sql .= " AND num_doc = 'B'";
} elseif ($tipo_doc === 'F') {
  $sql .= " AND num_doc = 'F'";
}
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $fecha_inicio, $fecha_fin);
$stmt->execute();
$result = $stmt->get_result();
// Cabeceras para Excel
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=yovera_corp_botica_compras_{$anio}_{$mes}.xls");
echo '<html><head><meta charset="UTF-8">';
echo '<style>
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid ##ffff00; padding: 8px; text-align: center; font-size: 14px; }
        th { background-color:rgb(90, 56, 44); color: white; font-weight: bold; }
        td { background-color: #f9f9f9; }
        tr:nth-child(even) { background-color: #f2f2f2; }
        tr:hover { background-color: #ddd; }
        .total { font-weight: bold; background-color: #e6f7ff; }
        .total td { text-align: right; }
        .total th { background-color:rgb(76,175,80); font-weight: bold; }
        .currency { mso-number-format:"\\S/ \\#,##0.00"; }
      </style>';
echo '</head><body>';
// Iniciar la tabla
// Encabezado tabla
echo "<table border='1'>";
echo "<tr>
        <th colspan='8'; font-size: 12px;>REPORTE DE COMPRAS YOVERA CORP E.I.R.L(BOTICA VIRGEN DE GUADALUPE) SUNAT - MES {$mes}/{$anio}</th>
      </tr>";
echo "<tr>
        <th style='width:35px;'>N°</th>
        <th style='width:85px;'>Fecha</th>
        <th style='width:95px;'>Documento</th>
        <th style='width:105px;'>DNI/RUC</th>
        <th style='width:455px;'>Proveedor</th>
        <th style='width:95px;'>Valor Compra</th>
        <th style='width:95px;'>I.G.V.</th>
        <th style='width:95px;'>Importe Total</th>
      </tr>";
$contador = 1;
$total_subtotal = 0;
$total_igv = 0;
$total_total = 0;
while ($row = $result->fetch_assoc()) {
  $total = $row['total'];
  $subtotal = $total / 1.18;
  $igv = $total - $subtotal;
  echo "<tr>
            <td style='text-align:center;'>{$contador}</td>
            <td style='text-align:center;'>{$row['fecha']}</td>
            <td style='text-align:center;'>{$row['num_doc']}</td>
            <td style='text-align:center;'>=" . '"' . (strlen($row['doc_ident']) > 1 ? $row['doc_ident'] : '00000000') . '"' . "</td>
            <td style='text-align:left;'>=" . '"' . (strlen($row['proveedor']) > 1 ? $row['proveedor'] : 'PROVEEDORES VARIOS') . '"' . "</td>
            <td style='text-align:right;'>" . number_format($subtotal, 2, '.', '') . "</td>
            <td style='text-align:right;'>" . number_format($igv, 2, '.', '') . "</td>
            <td style='text-align:right;'>" . number_format($total, 2, '.', '') . "</td>
          </tr>";
  $total_subtotal += $subtotal;
  $total_igv += $igv;
  $total_total += $total;
  $contador++;
}
// Fila de totales
echo "<tr style='font-weight:bold;'>
        <td colspan='5' style='text-align:right;background:#5a382c; font color:#f2f2f2'>Total General Compras en S/.   </td>
        <td style='text-align:right;'>" . number_format($total_subtotal, 2) . "</td>
        <td style='text-align:right;'>" . number_format($total_igv, 2) . "</td>
        <td style='text-align:right;'>" . number_format($total_total, 2) . "</td>
      </tr>";
echo "</table>";
exit;
?>