<?php
header("Content-Type: application/json");
$conn = new mysqli('localhost', 'root', '', 'yoveraes_botica');

if ($conn->connect_error) {
    die(json_encode(["error" => "Error de conexión a la base de datos"]));
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (!isset($_POST['id'])) {
        die(json_encode(["error" => "No se recibió el ID de la compra"]));
    }

    $idcompra = intval($_POST['id']);

    // Obtener los productos de la compra antes de eliminarlos
    $sql_detalle = "SELECT id_producto, cantidad FROM detalle_compras WHERE id_compra = ?";
    $stmt_detalle = $conn->prepare($sql_detalle);
    $stmt_detalle->bind_param("i", $idcompra);
    $stmt_detalle->execute();
    $result = $stmt_detalle->get_result();

    // Devolver el stock de los productos eliminados
    while ($row = $result->fetch_assoc()) {
        $id_producto = $row['id_producto'];
        $cantidad = $row['cantidad'];

        $sql_update_stock = "UPDATE producto SET existencia = existencia - ? WHERE codproducto = ?";
        $stmt_update = $conn->prepare($sql_update_stock);
        $stmt_update->bind_param("ii", $cantidad, $id_producto);
        $stmt_update->execute();
    }

    // Eliminar el detalle de la compra
    $sql_delete_detalle = "DELETE FROM detalle_compras WHERE id_compra = ?";
    $stmt_delete_detalle = $conn->prepare($sql_delete_detalle);
    $stmt_delete_detalle->bind_param("i", $idcompra);
    $stmt_delete_detalle->execute();

    // Eliminar la compra
    $sql_delete_compra = "DELETE FROM compras WHERE id = ?";
    $stmt_delete_compra = $conn->prepare($sql_delete_compra);
    $stmt_delete_compra->bind_param("i", $idcompra);

    if ($stmt_delete_compra->execute()) {
        echo json_encode(["success" => true]);
    } else {
        echo json_encode(["error" => "No se pudo eliminar la compra"]);
    }
}
?>